/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.IntSupplier;

public interface IntVec<S> {
    public S set(S var1);

    public S add(S var1);

    public S sub(S var1);

    public S mul(S var1);

    public S scale(int var1);

    public S min(S var1);

    public S max(S var1);

    public S abs();

    public S cross(S var1);

    public IntList values();

    public int length();

    public int lengthSqr();

    public int dist(S var1);

    public int distSqr(S var1);

    public int dot(S var1);

    public S zero();

    default public int get(int index) {
        return this.values().getInt(index);
    }

    default public int set(IntSupplier index, int value) {
        return this.values().set(index.getAsInt(), value);
    }

    default public int size() {
        return this.values().size();
    }

    default public S destroy() {
        return this.set(this.zero());
    }

    default public S inverse() {
        return this.scale(-1);
    }

    default public S normalize() {
        return this.scale(1 / this.length());
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

