/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.nio;

import com.google.common.io.ByteStreams;
import com.mr_toad.lib.api.client.utils.graphics.gl.ToadlyMemoryTracker;
import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import com.mr_toad.lib.mtjava.math.vec.base.FloatVec;
import com.mr_toad.lib.mtjava.math.vec.base.IntVec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.minecraft.class_2960;

public class MTNIO {
    public static ByteBuffer fromStream(InputStream stream) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
        ByteBuffer buffer = ToadlyMemoryTracker.byteAlloc(bytes.length);
        buffer.put(bytes).flip();
        return buffer;
    }

    public static void putId(ByteBuffer buffer, class_2960 id) {
        MTNIO.putString(buffer, id.toString());
    }

    public static void putString(ByteBuffer buffer, String s) {
        buffer.put(s.getBytes());
    }

    public static <V extends FloatVec<V>> void putFloatVec(ByteBuffer buffer, V vec) {
        vec.values().forEach(buffer::putFloat);
    }

    public static <V extends IntVec<V>> void putIntVec(ByteBuffer buffer, V vec) {
        vec.values().forEach(buffer::putInt);
    }

    public static <V extends DoubleVec<V>> void putDoubleVec(ByteBuffer buffer, V vec) {
        vec.values().forEach(buffer::putDouble);
    }

    public static String readString(ByteBuffer buffer, String s) {
        return MTNIO.readString(buffer, s.length());
    }

    public static String readString(ByteBuffer buffer, int length) {
        return MTNIO.readString(buffer, 0, length);
    }

    public static String readString(ByteBuffer buffer, int start, int length) {
        byte[] bytes = new byte[length];
        buffer.position(start);
        buffer.get(bytes, 0, length);
        return new String(bytes);
    }
}

