/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.init;

import com.mr_toad.lib.api.client.screen.config.widget.ConfigEntryWidgetMaker;
import com.mr_toad.lib.api.client.screen.config.widget.ConfigPageWidget;
import com.mr_toad.lib.api.client.screen.config.widget.UnexpectedEntry;
import com.mr_toad.lib.api.client.screen.ex.widget.ExCheckbox;
import com.mr_toad.lib.api.client.screen.ex.widget.ExEditBox;
import com.mr_toad.lib.api.client.screen.ex.widget.ExSlider;
import com.mr_toad.lib.api.client.screen.ex.widget.color.ColorCellsWidget;
import com.mr_toad.lib.api.client.screen.ex.widget.color.ColorPaletteWidget;
import com.mr_toad.lib.api.config.entry.ColorEntry;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.EnumEntry;
import com.mr_toad.lib.api.config.entry.primitive.NumericEntry;
import com.mr_toad.lib.api.config.entry.primitive.StringEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.error.ConfigException;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.math.MtMath;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ConfigEntryWidgetsRegistry {
    private static final Object2ObjectMap<ConfigEntryType, ConfigEntryWidgetMaker<?, ?, ?>> MAKERS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<ConfigEntryType, Consumer<class_364>> TICKERS = new Object2ObjectOpenHashMap();

    @ApiStatus.Internal
    public static void init() {
        ConfigEntryWidgetsRegistry.initMakers();
    }

    private static void initMakers() {
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BOOL, Boolean.TYPE, (owner, nextX, entry) -> {
            ExCheckbox checkbox = new ExCheckbox(nextX, 0, entry.getTitle(), (Boolean)entry.get(), b -> {
                if ((Boolean)entry.get() != b) {
                    entry.setValue(b);
                    owner.fillEntries();
                }
            });
            checkbox.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
            checkbox.field_22763 = !entry.isDeprecated();
            return checkbox;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.STRING, String.class, (owner, nextX, entry) -> {
            AtomicReference<String> lastContent = new AtomicReference<String>("");
            ExEditBox editBox = new ExEditBox(class_310.method_1551().field_1772, nextX, 0, 220, 20, entry.getTitle());
            editBox.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
            editBox.method_1856(false);
            if (entry instanceof StringEntry) {
                StringEntry stringEntry = (StringEntry)entry;
                editBox.method_1890(stringEntry.getFilter());
                editBox.method_1854(stringEntry.getProvider());
                editBox.method_1880(stringEntry.getMaxLength());
            } else {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to apply custom settings of string value: '{}'", (Object)entry);
            }
            editBox.method_1852((String)entry.get());
            editBox.method_1863(s -> {
                if (!((String)lastContent.get()).equals(s)) {
                    if (!((String)entry.get()).equals(s)) {
                        entry.setValue(s);
                        owner.fillEntries();
                    }
                    lastContent.set((String)s);
                }
            });
            editBox.field_22763 = !entry.isDeprecated();
            return editBox;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.ENUM, Enum.class, (owner, nextX, entry) -> {
            if (entry instanceof EnumEntry) {
                EnumEntry enumEntry = (EnumEntry)entry;
                class_5676 buttonWidget = class_5676.method_32606(enumEntry.getNaming()).method_32624((Object[])enumEntry.getValues()).method_32619(enumEntry.get()).method_32618(o -> class_7919.method_47407((class_2561)entry.getDescription())).method_32617(nextX, 9, 220, 20, entry.getTitle(), (b, v) -> {
                    if (!((Enum)enumEntry.get()).equals(v)) {
                        enumEntry.setValue((Enum)v);
                        owner.fillEntries();
                    }
                });
                buttonWidget.field_22763 = !entry.isDeprecated();
                return buttonWidget;
            }
            ToadLib.LOGGER.error(ToadLib.CONFIG, "'{}' is not enum!", (Object)entry);
            return new UnexpectedEntry(nextX, 0);
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BYTE, Byte.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).byteValue(), ((Number)numericEntry.getMax()).byteValue(), ((Byte)entry.get()).byteValue(), numericEntry.getStep(), num -> {
                        numericEntry.setValue(MtMath.bfloor(num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not byte!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.SHORT, Short.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).shortValue(), ((Number)numericEntry.getMax()).shortValue(), ((Short)entry.get()).shortValue(), numericEntry.getStep(), num -> {
                        numericEntry.setValue(MtMath.sfloor(num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not short!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.INT, Integer.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).intValue(), ((Number)numericEntry.getMax()).intValue(), ((Integer)entry.get()).intValue(), numericEntry.getStep(), num -> {
                        numericEntry.setValue(class_3532.method_15357((double)num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not int!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.LONG, Long.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).longValue(), ((Number)numericEntry.getMax()).longValue(), ((Long)entry.get()).longValue(), numericEntry.getStep(), num -> {
                        numericEntry.setValue(class_3532.method_15372((double)num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not long!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.LONG, Long.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).longValue(), ((Number)numericEntry.getMax()).longValue(), ((Long)entry.get()).longValue(), numericEntry.getStep(), num -> {
                        numericEntry.setValue(class_3532.method_15372((double)num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not long!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BIG_DECIMAL, BigDecimal.class, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), class_5244.field_39003, ((Number)numericEntry.getMin()).doubleValue(), ((Number)numericEntry.getMax()).doubleValue(), ((BigDecimal)entry.get()).doubleValue(), numericEntry.getStep(), false, num -> {
                        numericEntry.setValue(BigDecimal.valueOf(num.getValue()));
                        owner.fillEntries();
                    });
                    slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                    slider.field_22763 = !entry.isDeprecated();
                    return slider;
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' is not float/double!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.DEGREE, Float.TYPE, (owner, nextX, entry) -> {
            ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), (class_2561)class_2561.method_43470((String)"\u00b0"), -180.0, 180.0, ((Float)entry.get()).floatValue(), 1.0, num -> {
                entry.setValue(Float.valueOf((float)num.getValue()));
                owner.fillEntries();
            });
            slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
            slider.field_22763 = !entry.isDeprecated();
            return slider;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.PERCENT, Double.TYPE, (owner, nextX, entry) -> {
            ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), (class_2561)class_2561.method_43470((String)"%"), 0.0, 1.0, (Double)entry.get(), 0.01, num -> {
                entry.setValue(num.getValue());
                owner.fillEntries();
            }){

                @Override
                @NotNull
                public String getValueString(double value) {
                    return String.valueOf(value * 100.0);
                }
            };
            slider.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
            slider.field_22763 = !entry.isDeprecated();
            return slider;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.COLOR, Integer.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof ColorEntry) {
                    ColorEntry colorEntry = (ColorEntry)entry;
                    ColorEntry.Mode mode = colorEntry.getMode();
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case ColorEntry.Mode.PALETTE -> {
                            ColorPaletteWidget widget = new ColorPaletteWidget(class_310.method_1551(), nextX, 5, colorEntry.get(), entry.getTitle(), e -> {
                                colorEntry.setValue(e);
                                owner.fillEntries();
                            });
                            widget.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                            widget.setAlphaAllowed(colorEntry.isAllowAlpha());
                            widget.field_22763 = !entry.isDeprecated();
                            yield widget;
                        }
                        case ColorEntry.Mode.CELLS -> {
                            if (colorEntry.getCells().isEmpty()) {
                                throw new ConfigException("Cells color config entry is empty!");
                            }
                            int cellSize = colorEntry.getCellSize();
                            if (cellSize == 0) {
                                ToadLib.LOGGER.warn(ToadLib.CONFIG, "Cells of '{}' is invisible!", (Object)entry);
                            }
                            ColorCellsWidget widget = ColorCellsWidget.of(colorEntry.getCells(), e -> {
                                colorEntry.setValue(e);
                                owner.fillEntries();
                            }).addTitle(entry.getTitle()).size(nextX, 0, 90, 90).setCellSize(cellSize).build();
                            widget.method_47400(class_7919.method_47407((class_2561)entry.getDescription()));
                            widget.field_22763 = !entry.isDeprecated();
                            yield widget;
                        }
                    };
                }
                throw new ConfigException("'" + String.valueOf(entry) + "' isn't color!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e2) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e2);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.PAGE, class_2561.class, (owner, nextX, entry) -> new ConfigPageWidget(owner.widgetSelectionList.method_25322() / 2, 0, (class_2561)entry.get()));
    }

    public static <T, E extends ConfigEntry<T, E>, W extends class_364 & class_4068> void registerMaker(ConfigEntryType type, Class<T> of, ConfigEntryWidgetMaker<T, E, W> maker) {
        MAKERS.put((Object)type, maker);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered maker for '{}' of class '{}'", (Object)type, of);
    }

    public static void registerTicker(ConfigEntryType type, Consumer<class_364> ticker) {
        TICKERS.put((Object)type, ticker);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered ticker for '{}'", (Object)type);
    }

    public static Optional<ConfigEntryWidgetMaker<?, ?, ?>> getMakerOf(ConfigEntryType entryType) {
        return Optional.ofNullable((ConfigEntryWidgetMaker)MAKERS.get((Object)entryType));
    }

    public static Optional<Consumer<class_364>> getTickerOf(ConfigEntryType entryType) {
        return Optional.ofNullable((Consumer)TICKERS.get((Object)entryType));
    }
}

