/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.config;

import com.mr_toad.lib.api.client.init.ConfigEntryWidgetsRegistry;
import com.mr_toad.lib.api.client.screen.config.widget.ConfigEntryWidgetMaker;
import com.mr_toad.lib.api.client.screen.ex.ParentableToadLibScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.ExEditBox;
import com.mr_toad.lib.api.client.screen.ex.widget.LinkButton;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.api.client.screen.ex.widget.WidgetSelectionList;
import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.config.ToadConfigs;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.mtjava.collections.ImmutableArrayList;
import com.mr_toad.lib.mtjava.collections.execute.ExecutableArrayList;
import com.mr_toad.lib.mtjava.ints.IntPair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class ToadConfigScreen
extends ParentableToadLibScreen<class_437> {
    private static final class_2561 RESET = class_2561.method_43471((String)"toadconfig.reset");
    private final ExecutableArrayList tickable = new ExecutableArrayList();
    public final ToadConfig config;
    public WidgetSelectionList widgetSelectionList;
    public ExEditBox searchBox;
    public SpriteButton resetButton;
    public LinkButton fileButton;
    private boolean hasDeprecations = false;
    private boolean shouldReloadResources = false;
    private boolean needsUpdate = false;
    private Predicate<ConfigEntry<?, ?>> lastFilter = null;
    public String lastSearch = "";

    public ToadConfigScreen(class_437 parent, ToadConfig config) {
        super(class_5244.field_39003, true, parent, IntPair.of(20, 7));
        this.config = config;
    }

    @Override
    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.widgetSelectionList = (WidgetSelectionList)this.method_37063((class_364)new WidgetSelectionList(this.field_22787, this.field_22789, this.field_22790, 30, this.field_22790 - 20, 32));
        this.fillEntries(e -> true, true);
        class_5250 component = class_2561.method_43469((String)"toadconfig.search", (Object[])new Object[]{ToadConfigs.getConfigTitle(this.config)}).method_27692(class_124.field_1080);
        this.searchBox = (ExEditBox)this.method_37063((class_364)new ExEditBox(this.field_22793, this.field_22789 / 2 - 60, 7, 140, 20, (class_2561)component));
        this.searchBox.method_47404((class_2561)component);
        this.searchBox.method_1863(s -> {
            if (!Objects.equals(this.lastSearch, s)) {
                this.tickable.clear();
                this.fillEntries(e -> e.getType() != ConfigEntryTypes.PAGE && e.getTitle().getString().contains((CharSequence)s), this.lastSearch.isEmpty());
                this.lastSearch = s;
            }
        });
        this.searchBox.setRenderMagnifyingGlass(true);
        this.resetButton = (SpriteButton)this.method_37063((class_364)ToadClientUtils.createResetButton(40, 7, 20, 20, b -> {
            this.tickable.clear();
            this.config.getEntries().forEach(ConfigEntry::resetValue);
            this.resetButton.field_22763 = !this.config.getEntries().stream().allMatch(ConfigEntry::isDefault);
            this.fillEntries(e -> true, true);
            this.needsUpdate = true;
        }));
        this.resetButton.method_47400(class_7919.method_47407((class_2561)RESET));
        this.fileButton = (LinkButton)this.method_37063((class_364)new LinkButton(65, 7, 20, 20, LinkButton.DefaultType.COMMON_FILE, this.config.getConfig()));
        this.fileButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"toadconfig.open_file", (Object[])new Object[]{ToadConfigs.getConfigTitle(this.config)})));
        this.hasDeprecations = this.config.getEntries().stream().anyMatch(ConfigEntry::isDeprecated);
        super.method_25426();
    }

    public void method_25393() {
        this.tickable.run();
        super.method_25393();
    }

    @Override
    protected void onTurnBack() {
        super.onTurnBack();
        this.config.save();
        if (this.shouldReloadResources) {
            class_310.method_1551().method_1521();
        }
    }

    public void method_25419() {
        super.method_25419();
        this.config.save();
        if (this.shouldReloadResources) {
            class_310.method_1551().method_1521();
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.needsUpdate) {
            Predicate<ConfigEntry> filter = this.lastFilter == null ? e -> true : this.lastFilter;
            ImmutableArrayList<ConfigEntry> list = new ImmutableArrayList<ConfigEntry>(this.config.getEntries().stream().filter(filter).toList());
            for (int i = 0; i < list.size(); ++i) {
                class_339 widget = ((WidgetSelectionList.Entry)((Object)this.widgetSelectionList.method_25396().get((int)i))).widget;
                if (widget == null) continue;
                widget.field_22763 = !list.get(i).isDeprecated();
            }
            this.resetButton.field_22763 = !this.config.getEntries().stream().allMatch(ConfigEntry::isDefault);
            this.shouldReloadResources = this.config.getEntries().stream().anyMatch(ConfigEntry::mustReloadResource);
        }
    }

    public void fillEntries() {
        if (this.hasDeprecations) {
            this.needsUpdate = true;
        }
    }

    public void fillEntries(Predicate<ConfigEntry<?, ?>> filter, boolean drawPages) {
        int x = 15;
        this.widgetSelectionList.method_25339();
        ImmutableArrayList list = new ImmutableArrayList(this.config.getEntries().stream().filter(filter).toList());
        for (ConfigEntry<?, ?> entry : list) {
            ConfigEntryType type = entry.getType();
            if (!entry.drawInScreen() || type == ConfigEntryTypes.PAGE && !drawPages) {
                return;
            }
            Optional<ConfigEntryWidgetMaker<?, ?, ?>> optional = ConfigEntryWidgetsRegistry.getMakerOf(type);
            if (!optional.isPresent()) continue;
            ConfigEntryWidgetMaker<?, ?, ?> maker = optional.get();
            Object listener = maker.make(this, x, entry);
            ConfigEntryWidgetsRegistry.getTickerOf(type).ifPresent(consumer -> this.tickable.add(() -> consumer.accept(listener)));
            if (!(listener instanceof class_339)) continue;
            class_339 widget = (class_339)listener;
            widget.field_22763 = !entry.isDeprecated();
            this.widgetSelectionList.addEntry(new WidgetSelectionList.Entry(widget));
        }
        this.lastFilter = filter;
    }
}

