/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.ex.widget.color;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.lib.api.client.utils.graphics.Graphics2D;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.ints.IntPair;
import java.io.IOException;
import java.util.function.IntConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class ColorPaletteWidget
extends class_339 {
    private static final class_2960 SLIDER = class_2960.method_43902((String)"minecraft", (String)"textures/gui/slider.png");
    private static final class_2960 TEXTURE = ToadLib.id("textures/gui/widget/rgb_space.png");
    protected boolean alphaAllowed = true;
    @Nullable
    private IntPair currentPos = null;
    private int value;
    private final class_310 minecraft;
    private final IntConsumer change;
    private Element<Integer> palette;
    private Element<Float> alpha;

    public ColorPaletteWidget(class_310 minecraft, int x, int y, int value, IntConsumer change) {
        this(minecraft, x, y, value, class_5244.field_39003, change);
    }

    public ColorPaletteWidget(class_310 minecraft, int x, int y, int value, class_2561 component, IntConsumer change) {
        super(x, y, 95, 95, component);
        this.minecraft = minecraft;
        this.change = change;
        this.value = value;
        this.palette = new Element<Integer>(this.value, this.method_46426(), y - 10, 96, 64);
        this.alpha = new Element<Float>(Float.valueOf(1.0f), this.method_46426(), this.palette.y + this.palette.h + 5, 100, 15);
    }

    protected void method_48579(class_332 context, int mx, int my, float pt) {
        this.palette.render((v, x, y, w, h, hovered) -> {
            Graphics2D.fill(context, x - 1, y - 1, w + 2, h + 2, hovered ? MtJava.rgb2Argb(0xE0E0E0) : MtJava.rgb2Argb(0x404040));
            Graphics2D.scissor(context, x, y, w, h, () -> {
                context.method_25290(TEXTURE, x, y, 0.0f, 0.0f, w, h, w, h);
                if (this.currentPos != null) {
                    Graphics2D.point(context, (Integer)this.currentPos.getFirst(), (Integer)this.currentPos.getSecond(), this.getValue());
                }
            });
        }, mx, my);
        if (this.alphaAllowed) {
            this.alpha.render((v, x, y, w, h, hovered) -> {
                context.method_51422(1.0f, 1.0f, 1.0f, this.alpha.getValue().floatValue());
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                int yImage = (hovered ? 1 : 0) * 20;
                int vImage = (!hovered ? 2 : 3) * 20;
                context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
                this.method_49604(context, this.minecraft.field_1772, 2, i | class_3532.method_15386((float)(((Float)this.alpha.value).floatValue() * 255.0f)) << 24);
            }, mx, my);
        }
        int i = this.method_46426() + this.method_25368() + 5;
        int j = this.method_46427() + 5;
        context.method_25294(i - 1, j - 1, i + 16, j + 16, MtJava.rgb2Argb(0xE0E0E0));
        context.method_25294(i, j, i + 15, j + 15, MtJava.rgb2Argb(this.getValue()));
        if (this.method_25369() != class_5244.field_39003) {
            context.method_27534(this.minecraft.field_1772, this.method_25369(), this.method_46426() + this.method_25368() / 2, this.method_46427(), 0xE0E0E0);
        }
    }

    public boolean method_25402(double mx, double my, int button) {
        if (this.palette.isMouseOver(mx, my)) {
            return this.mousePaletteValue(mx, my);
        }
        if (this.isOnAlpha(mx, my)) {
            this.alpha.setValue(Float.valueOf(this.sliderValueFromMouse(mx)));
            this.onChange();
            return true;
        }
        return false;
    }

    public boolean method_25403(double mx, double my, int button, double dragX, double dragY) {
        if (this.palette.isMouseOver(mx, my)) {
            return this.mousePaletteValue(mx, my);
        }
        if (this.isOnAlpha(mx, my) && button == 0) {
            this.alpha.setValue(Float.valueOf(this.sliderValueFromMouse(mx)));
            this.onChange();
            return true;
        }
        return false;
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.palette = new Element<Integer>(this.value, this.method_46426(), y, 96, 64);
        this.alpha = new Element<Float>(Float.valueOf(1.0f), this.method_46426(), this.palette.y + this.palette.h + 5, 100, 15);
    }

    protected void method_47399(class_6382 builder) {
    }

    public void onChange() {
        this.updateValue();
        this.change.accept(this.value);
    }

    protected void updateValue() {
        int r = class_5253.class_5254.method_27765((int)this.palette.getValue());
        int g = class_5253.class_5254.method_27766((int)this.palette.getValue());
        int b = class_5253.class_5254.method_27767((int)this.palette.getValue());
        int a = this.alphaAllowed ? class_3532.method_15375((float)(this.alpha.getValue().floatValue() * 255.0f)) : 255;
        this.value = class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b);
    }

    protected float sliderValueFromMouse(double mx) {
        float value = (float)((mx - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
        value = class_3532.method_16439((float)class_3532.method_15363((float)value, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        value = 0.1f * (float)Math.round(value / 0.1f);
        return class_3532.method_37959((float)value, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }

    protected boolean mousePaletteValue(double mx, double my) {
        int mxp = class_3532.method_15357((double)mx);
        int myp = class_3532.method_15357((double)my);
        try {
            int i = Graphics2D.getPixelRGB(mxp - this.palette.x, myp - this.palette.y, TEXTURE);
            this.palette.setValue(i);
            this.currentPos = IntPair.of(mxp, myp);
            this.onChange();
            return true;
        }
        catch (IOException e) {
            ToadLib.LOGGER.error("Error during opening palette listener!", (Throwable)e);
            return false;
        }
    }

    protected boolean isOnAlpha(double mx, double my) {
        return this.alphaAllowed && this.alpha.isMouseOver(mx, my);
    }

    public int getValue() {
        return this.value;
    }

    public Element<Integer> getPalette() {
        return this.palette;
    }

    public Element<Float> getAlpha() {
        return this.alpha;
    }

    public void setAlphaAllowed(boolean alphaAllowed) {
        this.alphaAllowed = alphaAllowed;
    }

    public static class Element<T> {
        private T value;
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        public Element(T value, int x, int y, int w, int h) {
            this.value = value;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void render(ElementRenderer<T> renderer, int mx, int my) {
            renderer.render(this.getValue(), this.x, this.y, this.w, this.h, this.isMouseOver(mx, my));
        }

        public boolean isMouseOver(double mx, double my) {
            return mx >= (double)this.x && my >= (double)this.y && mx < (double)(this.x + this.w) && my < (double)(this.y + this.h);
        }

        public void setValue(T value) {
            this.value = value;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public T getValue() {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface ElementRenderer<T> {
        public void render(T var1, int var2, int var3, int var4, int var5, boolean var6);
    }
}

