/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.utils;

import com.google.common.collect.ImmutableList;
import com.mr_toad.lib.api.client.screen.config.ToadConfigsScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.core.ToadLib;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1091;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ToadClientUtils {
    public static final class_2561 SEARCH = class_2561.method_43471((String)"toadlib.search");
    public static final class_2960 CONFIG = ToadLib.id("textures/gui/widget/toadconfig.png");
    public static final class_2960 ICONS = ToadLib.id("textures/gui/widget/icons.png");
    public static final class_2960 INFO = ToadLib.id("textures/gui/widget/info.png");
    public static final class_2960 RESET = ToadLib.id("textures/gui/widget/reset.png");
    public static final class_2960 REFRESH = ToadLib.id("textures/gui/widget/refresh.png");
    public static final class_2960 MAGNIFYING_GLASS = ToadLib.id("textures/gui/widget/mg_glass.png");
    public static final int RED = 0xFF0000;
    public static final int ORANGE = 0xFF8000;
    public static final int YELLOW = 0xFFFF55;
    public static final int GREEN = 0x55FF55;
    public static final int LIGHT_BLUE = -1714618369;
    public static final int BLUE = 0x5555FF;
    public static final int PURPLE = 0x9933FF;
    public static final int DEFAULT = 0x404040;
    public static final int DEFAULT_TEXT = 0xE0E0E0;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int GRAY = 0xAAAAAA;
    public static final int LIGHT_GRAY = 0xA0A0A0;
    public static final int DARK_GREEN = 43520;

    public static class_1091 addMain(String modid, String name) {
        return ToadClientUtils.register(modid, name, "main");
    }

    public static class_1091 register(String modid, String name, String layer) {
        return new class_1091(class_2960.method_43902((String)modid, (String)name), layer);
    }

    public static SpriteButton createInfoButton(int x, int y, class_4185.class_4241 press) {
        SpriteButton button = SpriteButton.of(INFO, press).size(x, y, 20, 20).uv(0, 0).texSize(20, 20).setYDiff(hoveredOrFocused -> hoveredOrFocused ? 20 : 0).imageSize(64, 64).build();
        button.setShouldRenderTemp(false);
        return button;
    }

    public static SpriteButton createResetButton(int x, int y, int w, int h, class_4185.class_4241 press) {
        return SpriteButton.of(RESET, press).size(x, y, w, h).texSize(16, 16).imageSize(16, 16).buildCentred();
    }

    public static SpriteButton createRefreshButton(int x, int y, int w, int h, class_4185.class_4241 press) {
        return SpriteButton.of(REFRESH, press).size(x, y, w, h).texSize(16, 16).imageSize(16, 16).buildCentred();
    }

    public static <S extends class_437> SpriteButton createConfigButton(int x, int y, S parent) {
        return SpriteButton.of(CONFIG, b -> class_310.method_1551().method_1507(new ToadConfigsScreen<class_437>(parent))).size(x, y, 20, 20).imageSize(40, 40).texSize(21, 21).setYDiff(hoveredOrFocused -> hoveredOrFocused ? 21 : 0).setTooltip((class_2561)class_2561.method_43471((String)"toadconfig.title")).buildCentred();
    }

    public static void renderMagnifyingGlass(class_332 context, int x, int y, int w, int h) {
        context.method_25291(MAGNIFYING_GLASS, x, y, 0, 0.0f, 0.0f, 20, 20, w, h);
    }

    public static class_7919 extendTooltip(@Nullable class_7919 tooltip, class_2561 ... components) {
        if (tooltip == null) {
            if (components.length == 0) {
                ToadLib.LOGGER.error("Tooltip is null and length of extended elements are 0! Returned null.");
                return class_7919.method_47407((class_2561)class_5244.field_39003);
            }
            return class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])components));
        }
        if (components.length == 0) {
            return tooltip;
        }
        ImmutableList list = ImmutableList.builder().add((Object)tooltip.field_41102).add((Object[])components).build();
        return class_7919.method_47407((class_2561)class_5244.method_37109((Collection)list));
    }

    public static class_7919 extendTooltip(@Nullable class_7919 tooltip, class_2561 c, boolean newLine) {
        if (tooltip == null) {
            return class_7919.method_47407((class_2561)c);
        }
        class_2561 original = tooltip.field_41102;
        if (newLine) {
            return class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])new class_2561[]{original, c}));
        }
        return class_7919.method_47407((class_2561)original.method_27661().method_10852(c));
    }

    public static void openFile(File file) {
        class_156.method_668().method_673(file.toURI());
    }

    public static int centred(int v1, int w1, int w2) {
        return v1 + w1 / 2 - w2 / 2;
    }

    public static Optional<class_2583> getCentredStyleOf(class_327 font, class_2561 component, double mx, double my, int x, int y) {
        return ToadClientUtils.getStyleOf(font, component, mx, my, x - font.method_27525((class_5348)component) / 2, y);
    }

    public static Optional<class_2583> getStyleOf(class_327 font, class_2561 component, double mx, double my, int x, int y) {
        if (mx >= (double)x && my >= (double)y && mx < (double)(x + font.method_27525((class_5348)component))) {
            Objects.requireNonNull(font);
            if (my < (double)(y + 9)) {
                return Optional.of(component.method_10866());
            }
        }
        return Optional.empty();
    }
}

