/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.utils.graphics.gl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.lib.api.client.utils.graphics.GraphicsException;
import com.mr_toad.lib.core.ToadLib;
import java.util.function.IntSupplier;
import net.minecraft.class_4573;
import org.lwjgl.opengl.GL11;

public class GLU {
    public static void deleteBuffers(IntSupplier ... buffers) {
        GLU.callRender(() -> GLU._delBuffers(buffers));
    }

    public static void unbindBuffer(int target) {
        RenderSystem.glBindBuffer((int)target, () -> 0);
    }

    public static void pointSize(float size) {
        GL11.glPointSize((float)size);
    }

    public static void callRender(class_4573 call) {
        if (RenderSystem.isOnRenderThread()) {
            call.execute();
        } else {
            RenderSystem.recordRenderCall((class_4573)call);
        }
    }

    public static boolean checkErrors(boolean shutdown) {
        int error = GlStateManager._getError();
        if (error != 0) {
            ToadLib.LOGGER.error("OpenGL got error: {}", (Object)error);
            if (shutdown) {
                ToadLib.LOGGER.warn("Exiting...");
                throw new GraphicsException("'" + error + "'", GraphicsException.In.GL);
            }
            ToadLib.LOGGER.warn("This error may cause crash or optimization problems!");
            return false;
        }
        return true;
    }

    private static void _delBuffers(IntSupplier ... buffers) {
        for (IntSupplier buffer : buffers) {
            RenderSystem.glDeleteBuffers((int)buffer.getAsInt());
        }
    }
}

