/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.strings.func.StringSupplier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class ToadConfig {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ObjectList<ConfigEntry<?, ?>> entries = new ObjectArrayList();
    protected final String path;

    protected ToadConfig(StringSupplier path) {
        this.path = path.getAsString();
    }

    public void load() {
        if (Files.notExists(this.getConfig(), new LinkOption[0])) {
            this.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.getConfig(), StandardCharsets.UTF_8);){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.entries.forEach(configEntry -> {
                if (root.has(configEntry.toString())) {
                    JsonElement element = root.get(configEntry.toString());
                    configEntry.load(element);
                }
            });
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to load '{}'", (Object)this.path, (Object)e);
        }
    }

    public void save() {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getConfig().toFile()), StandardCharsets.UTF_8);){
            JsonObject object = new JsonObject();
            this.entries.forEach(configEntry -> configEntry.save(object));
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}'", (Object)this.path);
        }
    }

    public <T, E extends ConfigEntry<T, E>> E register(E instance) {
        this.entries.add(instance);
        return instance;
    }

    public ImmutableList<ConfigEntry<?, ?>> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public class_2561 title() {
        return class_2561.method_43473();
    }

    public Path getConfig() {
        return FabricLoader.getInstance().getConfigDir().resolve(this.path + ".json");
    }

    public boolean shouldCreateScreen() {
        return true;
    }
}

