/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry.primitive;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.error.ConfigException;
import com.mr_toad.lib.core.ToadLib;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class NumericEntry<S extends Number, N extends NumericEntry<S, N>>
extends ConfigEntry<S, N> {
    private float step = 1.0f;
    private boolean fatal = false;
    private Pair<S, S> range;

    protected NumericEntry(String name, S defaultValue, Codec<S> codec, ConfigEntryType type) {
        super(name, defaultValue, codec, type);
    }

    public abstract boolean inBounds(S var1, S var2, S var3);

    public abstract S safeMin();

    public abstract S safeMax();

    @Override
    public void setValue(S value) {
        if (this.checkBounds(value, this.range)) {
            if (this.fatal) {
                throw new ConfigException("New target of '" + this.name + "' not in bounds!");
            }
            ToadLib.LOGGER.error(ToadLib.CONFIG, "New target of '{}' not in bounds!", (Object)this.name);
            this.resetValue();
        } else {
            super.setValue(value);
        }
    }

    public N makeFatal() {
        this.fatal = true;
        return (N)this;
    }

    public N range(S min, S max) {
        if (min.equals(max)) {
            throw new ConfigException("Min and max cannot be equal! " + this.name);
        }
        if (((Number)min).doubleValue() > ((Number)max).doubleValue()) {
            throw new ConfigException("Illegal min/max combination! " + this.name);
        }
        this.range = Pair.of(min, max);
        if (this.checkBounds((Number)this.defaultValue, this.range)) {
            throw new ConfigException("Default target of '" + this.name + "' not in bounds!");
        }
        return (N)this;
    }

    public N setStep(float step) {
        this.step = step;
        return (N)this;
    }

    public boolean checkBounds(S v, @Nullable Pair<S, S> range) {
        if (range == null) {
            return false;
        }
        return !this.inBounds(v, (Number)range.getFirst(), (Number)range.getSecond());
    }

    public S getMax() {
        if (this.range == null) {
            return this.safeMax();
        }
        return (S)((Number)this.range.getSecond());
    }

    public S getMin() {
        if (this.range == null) {
            return this.safeMin();
        }
        return (S)((Number)this.range.getFirst());
    }

    public float getStep() {
        return this.step;
    }
}

