/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.entity.ai.goal;

import com.mr_toad.lib.api.entity.entitydata.BlowUpDataContainer;
import com.mr_toad.lib.api.util.SpawnLingeringCloudData;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class BlowUpGoal<M extends class_1314>
extends class_1352 {
    private int oldSwell;
    private int swell;
    private int maxSwell;
    @Nullable
    private class_1309 target;
    private final M mob;
    private float explosionRadius;
    private final double distToSqr;
    private final boolean shouldStopOnExplosion;
    private final boolean shouldExplodeIfNotSee;
    private final boolean invulnerableIfIgnited;
    @Nullable
    private final FloatPredicate hpPredicate;
    @Nullable
    private final class_3414 explosionSound;
    @Nullable
    private final SpawnLingeringCloudData lingeringCloudData;

    public BlowUpGoal(M mob, float explosionRadius, int maxSwell, double distToSqr, boolean shouldStopOnExplosion, boolean shouldExplodeIfNotSee, boolean invulnerableIfIgnited, @Nullable FloatPredicate hpPredicate, @Nullable class_3414 explosionSound, @Nullable SpawnLingeringCloudData lingeringCloudData) {
        this.mob = mob;
        this.explosionRadius = explosionRadius;
        this.maxSwell = maxSwell;
        this.distToSqr = distToSqr;
        this.shouldStopOnExplosion = shouldStopOnExplosion;
        this.shouldExplodeIfNotSee = shouldExplodeIfNotSee;
        this.invulnerableIfIgnited = invulnerableIfIgnited;
        this.hpPredicate = hpPredicate;
        this.explosionSound = explosionSound;
        this.lingeringCloudData = lingeringCloudData;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.shouldExplodeIfNotSee) {
            return this.canExplode() && !this.mob.method_5942().method_6357();
        }
        if (this.hpPredicate != null) {
            return this.canExplode() && this.hpPredicate.test(this.mob.method_6063());
        }
        return this.canExplode();
    }

    public void method_6269() {
        super.method_6269();
        if (this.shouldStopOnExplosion) {
            this.mob.method_5942().method_6340();
        }
        this.target = this.mob.method_5968();
        this.mob.method_19540(true);
    }

    public void method_6270() {
        super.method_6270();
        this.target = null;
        this.mob.method_19540(false);
    }

    public void method_6268() {
        if (this.target == null) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else if ((double)this.mob.method_5739((class_1297)this.target) > 49.0) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else if (!this.shouldExplodeIfNotSee && !this.mob.method_5985().method_6369((class_1297)this.target)) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else {
            ((BlowUpDataContainer)this.mob).setSwellDir(1);
        }
        if (this.mob.method_5805()) {
            int $$0;
            this.oldSwell = this.swell;
            if (((BlowUpDataContainer)this.mob).isIgnited()) {
                ((BlowUpDataContainer)this.mob).setSwellDir(1);
            }
            if (this.invulnerableIfIgnited) {
                this.mob.method_5679(this.mob.method_48923().method_48812(this.target));
            }
            if (($$0 = ((BlowUpDataContainer)this.mob).getSwellDir()) > 0 && this.swell == 0) {
                if (this.explosionSound != null) {
                    this.mob.method_5783(this.explosionSound, 1.0f, 0.5f);
                }
                this.mob.method_32876(class_5712.field_28727);
            }
            this.swell += $$0;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.method_6268();
    }

    public boolean method_38846() {
        return true;
    }

    public boolean canExplode() {
        return ((BlowUpDataContainer)this.mob).getSwellDir() > 0 || this.mob.method_5968() != null && (double)this.mob.method_5739((class_1297)this.mob.method_5968()) < this.distToSqr;
    }

    public float getSwelling(float sw) {
        return class_3532.method_16439((float)sw, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public void saveBlowUpData(class_2487 nbt) {
        nbt.method_10575("Fuse", (short)this.maxSwell);
        nbt.method_10548("ExplosionRadius", this.explosionRadius);
        nbt.method_10556("Ignited", ((BlowUpDataContainer)this.mob).isIgnited());
    }

    public void loadBlowUpData(class_2487 nbt) {
        if (nbt.method_10573("Fuse", 99)) {
            this.maxSwell = nbt.method_10568("Fuse");
        }
        if (nbt.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.method_10583("ExplosionRadius");
        }
        if (nbt.method_10577("Ignited")) {
            ((BlowUpDataContainer)this.mob).ignite();
        }
    }

    private void explode() {
        if (!this.mob.method_37908().method_8608()) {
            this.mob.method_37908().method_8437(this.mob, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), this.explosionRadius, class_1937.class_7867.field_40890);
            this.mob.method_31472();
            if (this.lingeringCloudData != null) {
                this.lingeringCloudData.spawn(SpawnLingeringCloudData.BY_ACTIVE_EFFECTS);
            }
        }
    }
}

