/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.helper.registry;

import com.mr_toad.lib.api.helper.registry.common.IdRegistry;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.mtjava.bytes.OptionalByte;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class SmallIdRegistry<O>
implements IdRegistry<Byte, O, Byte2ObjectMap<ValueHolder<O>>> {
    private final Byte2ObjectMap<ValueHolder<O>> registryMap = new Byte2ObjectOpenHashMap();
    private byte defaultValue = (byte)-1;
    private byte nextId = 0;
    private final String regName;

    public SmallIdRegistry(String regName) {
        Validate.notEmpty((CharSequence)regName, (String)"RegName cannot be empty!", (Object[])new Object[0]);
        this.regName = regName;
    }

    @Override
    public Byte2ObjectMap<ValueHolder<O>> registry() {
        return this.registryMap;
    }

    @Override
    public String regName() {
        return this.regName;
    }

    @Override
    @Nullable
    public ValueHolder<O> defaultValue() {
        if (this.defaultValue == -1) {
            return null;
        }
        return this.getOrThrow(this.defaultValue);
    }

    @Override
    public void destroyRegistry() {
        IdRegistry.super.destroyRegistry();
        this.nextId = 0;
        this.defaultValue = (byte)-1;
    }

    public void declareDefault() {
        this.declareDefault((byte)0);
    }

    public void declareDefault(byte id) {
        this.defaultValue = id;
    }

    public ValueHolder<O> register(O obj) {
        ValueHolder<O> holder = new ValueHolder<O>(obj);
        this.register(holder);
        return holder;
    }

    public ValueHolder<O> register(ValueHolder<O> obj) {
        byte by = this.nextId;
        this.nextId = (byte)(by + 1);
        this.registryMap.put(by, obj);
        return obj;
    }

    public ValueHolder<O> register(byte id, O obj) {
        ValueHolder<O> holder = new ValueHolder<O>(obj);
        this.register(id, holder);
        return holder;
    }

    public ValueHolder<O> register(byte id, ValueHolder<O> obj) {
        if (this.registryMap.containsKey(id)) {
            throw new IllegalArgumentException("'" + this.regName + "' already have object with id: '" + id + "'");
        }
        this.registryMap.put(id, obj);
        return obj;
    }

    public OptionalByte getDefaultId() {
        return this.defaultValue == -1 ? OptionalByte.empty() : OptionalByte.of(this.defaultValue);
    }

    public byte nextId() {
        while (this.hasId(this.nextId)) {
            this.nextId = (byte)(this.nextId + 1);
        }
        return this.nextId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SmallIdRegistry) {
            SmallIdRegistry other = (SmallIdRegistry)obj;
            if (!this.regName.equals(other.regName())) {
                return false;
            }
            if (this.size() == other.size()) {
                return this.values().equals(other.values());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int i = this.nextId;
        return (i *= 31) + this.registryMap.values().stream().mapToInt(ValueHolder::hashCode).sum() * 31;
    }

    public String toString() {
        return this.regName;
    }
}

