/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.concurrent;

import com.google.common.annotations.GwtIncompatible;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import it.unimi.dsi.fastutil.bytes.ByteBinaryOperator;
import it.unimi.dsi.fastutil.bytes.ByteUnaryOperator;
import java.io.Serializable;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

@GwtIncompatible
public final class AtomicByte
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    private static final long VALUE = UnsafeAccess.fieldOffset(AtomicByte.class, (String)"value");
    private volatile byte value;

    public AtomicByte(byte initial) {
        this.value = initial;
    }

    public AtomicByte() {
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public byte get() {
        return this.value;
    }

    public void set(byte v) {
        this.value = v;
    }

    public byte getByteVolatile() {
        return UNSAFE.getByteVolatile(this, VALUE);
    }

    public void lazySet(byte v) {
        UNSAFE.putByteVolatile(this, VALUE, v);
    }

    public byte getAndSet(byte newValue) {
        return this.getAndAdd(newValue);
    }

    public byte getAndAdd(byte newValue) {
        byte v;
        while (!this.compareAndSet(v = this.getByteVolatile(), newValue)) {
        }
        return v;
    }

    public byte addAndGet(byte delta) {
        return (byte)(this.getAndAdd(delta) + delta);
    }

    public byte getAndIncrement() {
        return this.getAndAdd((byte)1);
    }

    public byte getAndDecrement() {
        return this.getAndAdd((byte)-1);
    }

    public byte incrementAndGet() {
        return this.addAndGet((byte)1);
    }

    public byte decrementAndGet() {
        return this.addAndGet((byte)-1);
    }

    public boolean compareAndSet(byte expected, byte newValue) {
        return this.compareAndExchange(expected, newValue) == expected;
    }

    public byte compareAndExchange(byte expected, byte newValue) {
        int fullWord;
        long wordOffset = VALUE & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(VALUE & 3L) << 3;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (newValue & 0xFF) << shift;
        do {
            if (((fullWord = UNSAFE.getIntVolatile(this, wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!UNSAFE.compareAndSwapInt(this, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    public byte getAndUpdate(ByteUnaryOperator updateFunction) {
        byte prev = this.get();
        byte next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.apply(prev);
            }
            if (this.compareAndSet(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public byte updateAndGet(ByteUnaryOperator updateFunction) {
        byte prev = this.get();
        byte next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.apply(prev);
            }
            if (this.compareAndSet(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public byte getAndAccumulate(byte x, ByteBinaryOperator accumulatorFunction) {
        byte prev = this.get();
        byte next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.apply(prev, x);
            }
            if (this.compareAndSet(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public byte accumulateAndGet(byte x, ByteBinaryOperator accumulatorFunction) {
        byte prev = this.get();
        byte next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.apply(prev, x);
            }
            if (this.compareAndSet(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }
}

