/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math;

import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mr_toad.lib.mtjava.math.vec.Vec2f;
import com.mr_toad.lib.mtjava.math.vec.Vec3f;
import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import com.mr_toad.lib.mtjava.math.vec.base.FloatVec;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.math.BigDecimal;
import java.util.OptionalDouble;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.minecraft.class_3532;
import net.minecraft.class_5699;

public class MtMath {
    public static final Codec<BigDecimal> BIG_DECIMAL = class_5699.field_40721.flatXmap(f -> {
        try {
            return DataResult.success((Object)f.getAsBigDecimal());
        }
        catch (JsonParseException | UnsupportedOperationException e) {
            return DataResult.error(((RuntimeException)e)::getMessage);
        }
    }, d -> {
        try {
            return DataResult.success((Object)new JsonPrimitive((Number)d));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    });
    public static final float EPSILON = 1.0E-6f;
    public static final float EPSILON2 = 1.0E-4f;
    public static final float E = (float)Math.E;
    public static final float HALF_E = 1.3591409f;
    public static final float PI_INV = 0.31830987f;

    public static float pow(float value, float pow) {
        return (float)Math.pow(value, pow);
    }

    public static float exp(float v) {
        return (float)Math.exp(v);
    }

    public static float tan(float x) {
        return class_3532.method_15374((float)x) / class_3532.method_15362((float)x);
    }

    public static float cot(float x) {
        return 1.0f / MtMath.tan(x);
    }

    public static int sqrt(int i) {
        return (int)class_3532.method_15355((float)i);
    }

    public static int cbrt(int i) {
        return (int)Math.cbrt(i);
    }

    public static int sin(int x) {
        return (int)class_3532.method_15374((float)x);
    }

    public static int cos(int x) {
        return (int)class_3532.method_15362((float)x);
    }

    public static int tan(int x) {
        return MtMath.sin(x) / MtMath.cos(x);
    }

    public static int cot(int x) {
        return 1 / MtMath.tan(x);
    }

    public static double cot(double x) {
        return 1.0 / Math.tan(x);
    }

    public static float acos(float x) {
        return 1.5707964f - MtMath.asin(x);
    }

    public static float asin(float x) {
        boolean negate = x < 0.0f;
        x = class_3532.method_15379((float)x);
        float ret = class_3532.method_15355((float)(1.0f - x)) * (-0.0187293f * x + 0.074261f);
        ret = ret * x - 0.2121144f;
        ret = ret * x + 1.5707288f;
        ret = 1.5707963f - ret * class_3532.method_15355((float)(1.0f - x));
        return negate ? -ret : ret;
    }

    public static byte bfloor(double v) {
        byte i = (byte)v;
        return v < (double)i ? (byte)(i - 1) : i;
    }

    public static short sfloor(double v) {
        short i = (short)v;
        return v < (double)i ? (short)(i - 1) : i;
    }

    public static short clamp(short v, short min, short max) {
        return MtMath.min(MtMath.max(v, min), max);
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static short max(short a, short b) {
        return a >= b ? a : b;
    }

    public static byte clamp(byte v, byte min, byte max) {
        return MtMath.min(MtMath.max(v, min), max);
    }

    public static byte min(byte a, byte b) {
        return a <= b ? a : b;
    }

    public static byte max(byte a, byte b) {
        return a >= b ? a : b;
    }

    public static int sign(float v) {
        if (v == 0.0f) {
            return 0;
        }
        return v > 0.0f ? 1 : -1;
    }

    public static int hypot(int x, int y) {
        return (int)Math.hypot(x, y);
    }

    public static int trunc(int value) {
        return value - value % 2;
    }

    public static int average(int ... i) {
        return IntStream.of(i).sum() / i.length;
    }

    public static float average(float ... floats) {
        float f = 0.0f;
        for (float f1 : floats) {
            f += f1;
        }
        return f / (float)floats.length;
    }

    public static double average(double ... doubles) {
        OptionalDouble optionalDouble = DoubleStream.of(doubles).average();
        if (optionalDouble.isPresent()) {
            return optionalDouble.getAsDouble();
        }
        return 0.0;
    }

    public static int length(int x, int y) {
        return MtMath.sqrt(MtMath.lengthSquared(x, y));
    }

    public static int length(int x, int y, int z) {
        return MtMath.sqrt(MtMath.lengthSquared(x, y, z));
    }

    public static int length(int x, int y, int z, int w) {
        return MtMath.sqrt(MtMath.lengthSquared(x, y, z, w));
    }

    public static int lengthSquared(int x, int y) {
        return x * x + y * y;
    }

    public static int lengthSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public static int lengthSquared(int x, int y, int z, int w) {
        return x * x + y * y + z * z + w * w;
    }

    public static float length(float x, float y) {
        return class_3532.method_15355((float)MtMath.lengthSquared(x, y));
    }

    public static float length(float x, float y, float z) {
        return class_3532.method_15355((float)MtMath.lengthSquared(x, y, z));
    }

    public static float length(float x, float y, float z, float w) {
        return class_3532.method_15355((float)MtMath.lengthSquared(x, y, z, w));
    }

    public static float lengthSquared(float x, float y) {
        return x * x + y * y;
    }

    public static float lengthSquared(float x, float y, float z) {
        return x * x + y * y + z * z;
    }

    public static float lengthSquared(float x, float y, float z, float w) {
        return x * x + y * y + z * z + w * w;
    }

    public static double length(double x, double y) {
        return Math.sqrt(MtMath.lengthSquared(x, y));
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(MtMath.lengthSquared(x, y, z));
    }

    public static double length(double x, double y, double z, double w) {
        return Math.sqrt(MtMath.lengthSquared(x, y, z, w));
    }

    public static double lengthSquared(double x, double y) {
        return x * x + y * y;
    }

    public static double lengthSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double lengthSquared(double x, double y, double z, double w) {
        return x * x + y * y + z * z + w * w;
    }

    public static float fact(float v) {
        int fact = 1;
        int i = 1;
        while ((float)i <= v) {
            fact *= i;
            ++i;
        }
        return fact;
    }

    public static boolean isNanOrInfinite(BigDecimal decimal) {
        return MtMath.isNan(decimal) || MtMath.isInfinite(decimal);
    }

    public static boolean isInfinite(BigDecimal decimal) {
        return Double.isInfinite(decimal.doubleValue());
    }

    public static boolean isNan(BigDecimal decimal) {
        return Double.isNaN(decimal.doubleValue());
    }

    public static <V extends DoubleVec<V>> V ceil(V vec) {
        return MtMath.mapValuesVec(vec, Math::ceil);
    }

    public static <V extends FloatVec<V>> V ceil(V vec) {
        return MtMath.mapValuesVec(vec, class_3532::method_15386);
    }

    public static <V extends DoubleVec<V>> V floor(V vec) {
        return MtMath.mapValuesVec(vec, Math::floor);
    }

    public static <V extends FloatVec<V>> V floor(V vec) {
        return MtMath.mapValuesVec(vec, class_3532::method_15375);
    }

    public static <V extends DoubleVec<V>> V round(V vec) {
        return MtMath.mapValuesVec(vec, Math::round);
    }

    public static <V extends FloatVec<V>> V round(V vec) {
        return MtMath.mapValuesVec(vec, Math::round);
    }

    public static <V extends DoubleVec<V>> V mapValuesVec(V vec, Double2DoubleFunction mapper) {
        for (int i = 0; i < vec.values().size(); ++i) {
            double old = vec.get(i);
            double newValue = (Double)mapper.apply((Object)old);
            vec.set(i, newValue);
        }
        return vec;
    }

    public static <V extends FloatVec<V>> V mapValuesVec(V vec, Float2FloatFunction mapper) {
        for (int i = 0; i < vec.values().size(); ++i) {
            float old = vec.get(i);
            float newValue = ((Float)mapper.apply((Object)Float.valueOf(old))).floatValue();
            vec.set(i, newValue);
        }
        return vec;
    }

    public static Vec2f getCenter(Vec2f vec1, Vec2f vec2) {
        float x = class_3532.method_16439((float)0.5f, (float)vec1.x(), (float)vec2.x());
        float y = class_3532.method_16439((float)0.5f, (float)vec1.y(), (float)vec2.y());
        return new Vec2f(x, y);
    }

    public static Vec3f getCenter(Vec3f vec1, Vec3f vec2) {
        float x = class_3532.method_16439((float)0.5f, (float)vec1.x(), (float)vec2.x());
        float y = class_3532.method_16439((float)0.5f, (float)vec1.y(), (float)vec2.y());
        float z = class_3532.method_16439((float)0.5f, (float)vec1.z(), (float)vec2.z());
        return new Vec3f(x, y, z);
    }

    public static String component2Name(int index) {
        return switch (index) {
            case 0 -> "X";
            case 1 -> "Y";
            case 2 -> "Z";
            case 3 -> "W";
            default -> "Unknown";
        };
    }
}

