/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import com.mr_toad.lib.mtjava.nio.MTNIO;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2540;

public interface FloatVec<S extends FloatVec<S>> {
    public static <S extends FloatVec<S>> S load(Supplier<S> empty, class_2499 list) {
        FloatVec vec = (FloatVec)empty.get();
        List<class_2494> tags = list.stream().map(class_2494.class::cast).toList();
        for (int i = 0; i < tags.size(); ++i) {
            vec.set(i, tags.get(i).method_10700());
        }
        return (S)vec;
    }

    public static <S extends FloatVec<S>> S read(Supplier<S> empty, class_2540 buf) {
        FloatVec vec = (FloatVec)empty.get();
        FloatList floats = MTNIO.readFloatList(buf);
        for (int i = 0; i < floats.size(); ++i) {
            vec.set(i, floats.getFloat(i));
        }
        return (S)vec;
    }

    public S set(S var1);

    public S set(int var1, float var2);

    public S set(float var1);

    public S add(S var1);

    public S sub(S var1);

    public S mul(S var1);

    public S div(S var1);

    public S scale(float var1);

    public S min(S var1);

    public S max(S var1);

    public S abs();

    public S cross(S var1);

    public FloatList values();

    public float length();

    public float lengthSqr();

    public float dist(S var1);

    public float distSqr(S var1);

    public float dot(S var1);

    public S zero();

    public S create();

    default public float get(int index) {
        return this.values().getFloat(index);
    }

    default public int size() {
        return this.values().size();
    }

    default public S destroy() {
        return this.set(this.zero());
    }

    default public S inverse() {
        return this.scale(-1.0f);
    }

    default public S def(float scalar) {
        return this.scale(1.0f / scalar);
    }

    default public S normalize() {
        return this.def(this.length());
    }

    default public void setIf(FloatPredicate predicate, FloatUnaryOperator v) {
        for (int i = 0; i < this.values().doubleStream().filter(arg_0 -> ((FloatPredicate)predicate).test(arg_0)).toArray().length; ++i) {
            this.set(i, v.apply(this.get(i)));
        }
    }

    default public void setIf(FloatPredicate predicate, float v) {
        for (int i = 0; i < this.values().doubleStream().filter(arg_0 -> ((FloatPredicate)predicate).test(arg_0)).toArray().length; ++i) {
            this.set(i, v);
        }
    }

    default public boolean anyEqual(float v) {
        return this.values().doubleStream().anyMatch(d -> d == (double)v);
    }

    default public boolean allEqual(float v) {
        return this.values().doubleStream().allMatch(d -> d == (double)v);
    }

    default public boolean noneEqual(float v) {
        return this.values().doubleStream().noneMatch(d -> d == (double)v);
    }

    default public class_2499 save() {
        class_2499 list = new class_2499();
        FloatListIterator floatListIterator = this.values().iterator();
        while (floatListIterator.hasNext()) {
            float value = ((Float)floatListIterator.next()).floatValue();
            list.add((Object)class_2494.method_23244((float)value));
        }
        return list;
    }

    default public void write(class_2540 buf) {
        buf.method_34062((Collection)this.values(), class_2540::writeFloat);
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

