/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.khloeleclair.create.additionallogistics.common.blockentities.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.EncasedFlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class LowEntityKineticBlockEntityRenderer
extends KineticBlockEntityRenderer<AbstractLowEntityKineticBlockEntity> {
    public static boolean overrideVisualization;

    public LowEntityKineticBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderOpenings(AbstractLowEntityKineticBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        boolean encased = be.getBlockState().getBlock() instanceof EncasedFlexibleShaftBlock;
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        for (Direction dir : Iterate.directions) {
            int l;
            float modifier = be.getRotationSpeedModifier(dir);
            if (modifier == 0.0f) continue;
            int n = l = encased ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos.relative(dir)) : light;
            SuperByteBuffer opening = CachedBuffers.partialFacing((PartialModel)(modifier == 1.0f ? (encased ? CALPartialModels.ENCASED_SHAFT_OPENING : CALPartialModels.SHAFT_OPENING) : (encased ? CALPartialModels.ENCASED_SHAFT_OPENING_REVERSED : CALPartialModels.SHAFT_OPENING_REVERSED)), (BlockState)be.getBlockState(), (Direction)dir.getOpposite());
            opening.light(l).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
    }

    protected void renderSafe(AbstractLowEntityKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            this.renderOpenings(be, ms, buffer, light);
            return;
        }
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float baseAngle = time * be.getSpeed() * 3.0f / 10.0f % 360.0f;
        BlockState state = be.getBlockState();
        boolean encased = state.getBlock() instanceof EncasedFlexibleShaftBlock;
        Block block = state.getBlock();
        if (block instanceof ICogWheel) {
            ICogWheel cog = (ICogWheel)block;
            if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
                Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
                boolean large = cog.isLargeCog();
                SuperByteBuffer cogmodel = CachedBuffers.partialFacingVertical((PartialModel)(large ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL), (BlockState)state, (Direction)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                LowEntityKineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)cogmodel, (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
            }
        }
        for (Direction dir : Iterate.directions) {
            int l;
            float modifier = be.getRotationSpeedModifier(dir);
            if (modifier == 0.0f) continue;
            Direction.Axis axis = dir.getAxis();
            float offset = LowEntityKineticBlockEntityRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
            float angle = baseAngle * modifier;
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            int n = l = encased ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos.relative(dir)) : light;
            SuperByteBuffer opening = CachedBuffers.partialFacing((PartialModel)(modifier == 1.0f ? (encased ? CALPartialModels.ENCASED_SHAFT_OPENING : CALPartialModels.SHAFT_OPENING) : (encased ? CALPartialModels.ENCASED_SHAFT_OPENING_REVERSED : CALPartialModels.SHAFT_OPENING_REVERSED)), (BlockState)state, (Direction)dir.getOpposite());
            opening.light(l).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
            SuperByteBuffer shaft = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.getBlockState(), (Direction)dir);
            LowEntityKineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)l);
            shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        }
    }
}

