/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.screen;

import dev.khloeleclair.create.additionallogistics.client.widgets.BlockPreviewWidget;
import dev.khloeleclair.create.additionallogistics.common.blockentities.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.EncasedFlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.blocks.FlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.network.CustomPackets;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FlexibleShaftScreen
extends AbstractSimiScreen {
    private final BlockPos pos;
    private final Level level;
    private final Player player;
    private BlockPreviewWidget widget;
    private Component label;

    public FlexibleShaftScreen(BlockPos pos) {
        this.pos = pos;
        this.player = Minecraft.getInstance().player;
        this.level = Minecraft.getInstance().level;
        this.label = this.level.getBlockState(pos).getBlock().getName();
    }

    protected void init() {
        super.init();
        GridLayout layout = new GridLayout();
        layout.defaultCellSetting().padding(2).alignVerticallyMiddle().alignHorizontallyCenter();
        GridLayout.RowHelper helper = layout.createRowHelper(1);
        helper.addChild((LayoutElement)new StringWidget(this.label, Minecraft.getInstance().font).alignCenter());
        this.widget = new BlockPreviewWidget(0, 0, 600, 300, this.pos);
        this.widget.canSelectDirection(dir -> {
            BlockState state = this.level.getBlockState(this.pos);
            if (!(state.getBlock() instanceof FlexibleShaftBlock)) {
                return false;
            }
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof EncasedFlexibleShaftBlock) {
                EncasedFlexibleShaftBlock fsb = (EncasedFlexibleShaftBlock)patt0$temp;
                return !fsb.connectsTo((LevelAccessor)this.level, this.pos, state, (Direction)dir);
            }
            BooleanProperty prop = FlexibleShaftBlock.SIDES[dir.ordinal()];
            return (Boolean)state.getValue((Property)prop) == false;
        });
        this.widget.onClick((dir, button) -> {
            byte target;
            byte existing;
            BlockEntity patt0$temp = this.level.getBlockEntity(this.pos);
            if (patt0$temp instanceof FlexibleShaftBlockEntity) {
                FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)patt0$temp;
                existing = fsb.getSide((Direction)dir);
            } else {
                existing = 0;
            }
            if (button == 0) {
                target = switch (existing) {
                    case 1 -> -1;
                    case -1 -> 0;
                    default -> 1;
                };
            } else {
                target = switch (existing) {
                    case 1 -> 0;
                    case -1 -> 1;
                    default -> -1;
                };
            }
            CustomPackets.ConfigureFlexibleShaft.of(this.pos, dir, target).send();
        });
        helper.addChild((LayoutElement)this.widget);
        layout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)layout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.5f);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void onClose() {
        super.onClose();
        CustomPackets.FinishedConfiguringFlexibleShaft.of(this.pos).send();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.widget.visible && this.widget.isMouseOver(mouseX, mouseY)) {
            return this.widget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.widget.visible && this.widget.isMouseOver(mouseX, mouseY)) {
            return this.widget.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }
}

