/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.visuals;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.khloeleclair.create.additionallogistics.common.blockentities.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.EncasedFlexibleShaftBlock;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;

public class FlexibleShaftVisual
extends KineticBlockEntityVisual<FlexibleShaftBlockEntity> {
    protected final EnumMap<Direction, RotatingInstance> keys = new EnumMap(Direction.class);

    public FlexibleShaftVisual(VisualizationContext context, FlexibleShaftBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Instancer instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        float speed = blockEntity.getSpeed();
        for (Direction dir : Iterate.directions) {
            byte mode = blockEntity.getSide(dir);
            float s = mode == -1 ? -speed : speed;
            RotatingInstance instance = (RotatingInstance)instancer.createInstance();
            instance.setup((KineticBlockEntity)blockEntity, dir.getAxis(), s).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, dir).setChanged();
            instance.setVisible(mode != 0);
            this.keys.put(dir, instance);
        }
    }

    public void update(float partialTick) {
        super.update(partialTick);
        float speed = ((FlexibleShaftBlockEntity)this.blockEntity).getSpeed();
        for (Map.Entry<Direction, RotatingInstance> entry : this.keys.entrySet()) {
            Direction dir = entry.getKey();
            byte mode = ((FlexibleShaftBlockEntity)this.blockEntity).getSide(dir);
            float s = mode == -1 ? -speed : speed;
            RotatingInstance instance = entry.getValue();
            instance.setup((KineticBlockEntity)this.blockEntity, dir.getAxis(), s).setChanged();
            instance.setVisible(mode != 0);
        }
    }

    public void updateLight(float partialTick) {
        if (this.blockState.getBlock() instanceof EncasedFlexibleShaftBlock) {
            for (Map.Entry<Direction, RotatingInstance> entry : this.keys.entrySet()) {
                this.relight(this.pos.relative(entry.getKey()), new FlatLit[]{(FlatLit)entry.getValue()});
            }
        } else {
            this.relight((FlatLit[])this.keys.values().toArray(FlatLit[]::new));
        }
    }

    protected void _delete() {
        this.keys.values().forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        this.keys.values().forEach(consumer);
    }
}

