/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.widgets;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.client.renderers.LowEntityKineticBlockEntityRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BlockPreviewWidget
extends AbstractWidget {
    private static final Quaternionf ROT_180_Z = Axis.ZP.rotation((float)Math.PI);
    private static final Vec3 RAY_ORIGIN = new Vec3(1.5, 1.5, 1.5);
    private static final Vec3 RAY_START = new Vec3(1.5, 1.5, -1.0);
    private static final Vec3 RAY_END = new Vec3(1.5, 1.5, 3.0);
    private static final BlockPos POS = new BlockPos(1, 1, 1);
    private static final int Z_OFFSET = 100;
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    private static final ResourceLocation SELECTED_ICON = CreateAdditionalLogistics.asResource("block/highlighted");
    private static MultiBufferSource.BufferSource ghostBuffers;
    private static MultiBufferSource.BufferSource solidBuffers;
    private final Vector3f worldOrigin;
    @Nullable
    private Predicate<Direction> canSelectDirection;
    @Nullable
    private BiConsumer<Direction, Integer> clickedDiration;
    private final BlockPos position;
    private final List<BlockPos> neighbors = new ArrayList<BlockPos>();
    private float scale = 80.0f;
    private float pitch;
    private float yaw;
    private boolean didClick = false;
    private boolean neighborsVisible = true;
    private Optional<SelectedFace> selection = Optional.empty();

    public BlockPreviewWidget(int x, int y, int width, int height, BlockPos position) {
        super(x, y, width, height, (Component)Component.empty());
        this.position = position;
        this.worldOrigin = new Vector3f((float)position.getX() + 0.5f, (float)position.getY() + 0.5f, (float)position.getZ() + 0.5f);
        for (Direction dir : Iterate.directions) {
            this.neighbors.add(position.relative(dir));
        }
        this.pitch = BlockPreviewWidget.MINECRAFT.player.getXRot();
        this.yaw = BlockPreviewWidget.MINECRAFT.player.getYRot();
        this.initBuffers(MINECRAFT.renderBuffers().bufferSource());
    }

    public BlockPreviewWidget canSelectDirection(@Nullable Predicate<Direction> predicate) {
        this.canSelectDirection = predicate;
        return this;
    }

    public BlockPreviewWidget onClick(@Nullable BiConsumer<Direction, Integer> consumer) {
        this.clickedDiration = consumer;
        return this;
    }

    private void initBuffers(MultiBufferSource.BufferSource original) {
        ByteBufferBuilder fallback = original.sharedBuffer;
        SequencedMap layerBuffers = original.fixedBuffers;
        Object2ObjectLinkedOpenHashMap ghostLayers = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap solidLayers = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            ghostLayers.put(GhostRenderLayer.remap((RenderType)e.getKey()), (ByteBufferBuilder)e.getValue());
            solidLayers.put(SolidRenderLayer.remap((RenderType)e.getKey()), (ByteBufferBuilder)e.getValue());
        }
        ghostBuffers = new GhostBuffers(fallback, (SequencedMap<RenderType, ByteBufferBuilder>)ghostLayers);
        solidBuffers = new SolidBuffers(fallback, (SequencedMap<RenderType, ByteBufferBuilder>)solidLayers);
    }

    private static Vec3 transform(Vec3 vec, Matrix4f transform) {
        Vector4f vec4 = new Vector4f((float)(vec.x - BlockPreviewWidget.RAY_ORIGIN.x), (float)(vec.y - BlockPreviewWidget.RAY_ORIGIN.y), (float)(vec.z - BlockPreviewWidget.RAY_ORIGIN.z), 1.0f);
        vec4.mul((Matrix4fc)transform);
        return new Vec3((double)vec4.x() + BlockPreviewWidget.RAY_ORIGIN.x, (double)vec4.y() + BlockPreviewWidget.RAY_ORIGIN.y, (double)vec4.z() + BlockPreviewWidget.RAY_ORIGIN.z);
    }

    @Nullable
    private BlockHitResult raycast(BlockPos pos, BlockState state, float diffX, float diffY, Matrix4f transform) {
        Vec3 start = RAY_START.add((double)diffX, (double)diffY, 0.0);
        Vec3 end = RAY_END.add((double)diffX, (double)diffY, 0.0);
        start = BlockPreviewWidget.transform(start, transform);
        end = BlockPreviewWidget.transform(end, transform);
        VoxelShape shape = Shapes.block();
        Vector3f centerPos = new Vector3f((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f).sub((Vector3fc)this.worldOrigin);
        shape = shape.move((double)centerPos.x(), (double)centerPos.y(), (double)centerPos.z());
        return shape.clip(start, end, POS);
    }

    public void toggleNeighborVisibility() {
        this.neighborsVisible = !this.neighborsVisible;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.didClick = false;
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.didClick && this.selection.isPresent() && this.clickedDiration != null) {
            this.clickedDiration.accept(this.selection.get().side, button);
        }
        this.didClick = false;
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.didClick = true;
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.didClick = false;
        if (this.visible && this.isValidClickButton(button) && this.isMouseOver(mouseX, mouseY)) {
            double dx = dragX / (double)MINECRAFT.getWindow().getGuiScaledWidth();
            double dy = dragY / (double)MINECRAFT.getWindow().getGuiScaledHeight();
            this.yaw += 4.0f * (float)dx * 180.0f;
            this.pitch += 2.0f * (float)dy * 180.0f;
            this.pitch = Math.min(80.0f, Math.max(-80.0f, this.pitch));
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.visible) {
            this.scale -= (float)scrollY;
            this.scale = Math.min(160.0f, Math.max(10.0f, this.scale));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        LowEntityKineticBlockEntityRenderer.overrideVisualization = true;
        try {
            guiGraphics.enableScissor(x, y, x + this.width, y + this.height);
            int centerX = this.getX() + this.width / 2;
            int centerY = this.getY() + this.height / 2;
            float diffX = (float)(mouseX - centerX) / this.scale;
            float diffY = (float)(mouseY - centerY) / this.scale;
            Quaternionf rotPitch = Axis.XN.rotationDegrees(this.pitch);
            Quaternionf rotYaw = Axis.YP.rotationDegrees(this.yaw);
            Quaternionf blockTransform = new Quaternionf((Quaternionfc)ROT_180_Z);
            blockTransform.mul((Quaternionfc)rotPitch);
            blockTransform.mul((Quaternionfc)rotYaw);
            this.renderWorld(guiGraphics, centerX, centerY, blockTransform, partialTick);
            Matrix4f rayTransform = new Matrix4f();
            rayTransform.set((Quaternionfc)ROT_180_Z);
            rayTransform.rotate((Quaternionfc)rotYaw);
            rayTransform.rotate((Quaternionfc)rotPitch);
            HashMap<BlockHitResult, BlockPos> hits = new HashMap<BlockHitResult, BlockPos>();
            BlockState state = BlockPreviewWidget.MINECRAFT.level.getBlockState(this.position);
            BlockHitResult hit = this.raycast(this.position, state, diffX, diffY, rayTransform);
            if (hit != null && hit.getType() != HitResult.Type.MISS && (this.canSelectDirection == null || this.canSelectDirection.test(hit.getDirection()))) {
                hits.put(hit, this.position);
            }
            Vec3 eyePosition = BlockPreviewWidget.transform(RAY_START, rayTransform).add((double)this.worldOrigin.x, (double)this.worldOrigin.y, (double)this.worldOrigin.z);
            this.selection = hits.entrySet().stream().min(Comparator.comparingDouble(entry -> ((BlockPos)entry.getValue()).distToCenterSqr((Position)eyePosition))).map(closest -> new SelectedFace((BlockPos)closest.getValue(), ((BlockHitResult)closest.getKey()).getDirection()));
            this.renderSelection(guiGraphics, centerX, centerY, blockTransform);
            guiGraphics.disableScissor();
        }
        finally {
            LowEntityKineticBlockEntityRenderer.overrideVisualization = false;
        }
    }

    private void renderWorld(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform, float partialTick) {
        Lighting.setupForFlatItems();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)centerX, (float)centerY, 100.0f);
        guiGraphics.pose().scale(this.scale, this.scale, -this.scale);
        guiGraphics.pose().mulPose(transform);
        if (this.neighborsVisible) {
            for (BlockPos neighbour : this.neighbors) {
                Vector3f pos = new Vector3f((float)neighbour.getX() - this.worldOrigin.x(), (float)neighbour.getY() - this.worldOrigin.y(), (float)neighbour.getZ() - this.worldOrigin.z());
                this.renderBlock(guiGraphics, neighbour, pos, ghostBuffers, partialTick);
            }
        }
        ghostBuffers.endBatch();
        Vector3f pos = new Vector3f((float)this.position.getX() - this.worldOrigin.x(), (float)this.position.getY() - this.worldOrigin.y(), (float)this.position.getZ() - this.worldOrigin.z());
        this.renderBlock(guiGraphics, this.position, pos, solidBuffers, partialTick);
        solidBuffers.endBatch();
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    private void renderBlock(GuiGraphics guiGraphics, BlockPos blockPos, Vector3f renderPos, MultiBufferSource.BufferSource buffers, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(renderPos.x(), renderPos.y(), renderPos.z());
        ModelData modelData = Optional.ofNullable(BlockPreviewWidget.MINECRAFT.level.getModelDataManager().getAt(blockPos)).orElse(ModelData.EMPTY);
        BlockState blockState = BlockPreviewWidget.MINECRAFT.level.getBlockState(blockPos);
        RenderShape rendershape = blockState.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            BlockEntityRenderer beRenderer;
            BlockEntity blockEntity;
            if (rendershape == RenderShape.MODEL) {
                BlockRenderDispatcher renderer = MINECRAFT.getBlockRenderer();
                BakedModel bakedmodel = renderer.getBlockModel(blockState);
                modelData = bakedmodel.getModelData((BlockAndTintGetter)BlockPreviewWidget.MINECRAFT.level, blockPos, blockState, modelData);
                int blockColor = MINECRAFT.getBlockColors().getColor(blockState, (BlockAndTintGetter)BlockPreviewWidget.MINECRAFT.level, blockPos, 0);
                float r = (float)FastColor.ARGB32.red((int)blockColor) / 255.0f;
                float g = (float)FastColor.ARGB32.green((int)blockColor) / 255.0f;
                float b = (float)FastColor.ARGB32.blue((int)blockColor) / 255.0f;
                for (RenderType renderType : bakedmodel.getRenderTypes(blockState, RandomSource.create((long)42L), modelData)) {
                    renderer.getModelRenderer().renderModel(guiGraphics.pose().last(), buffers.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), blockState, bakedmodel, r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, renderType);
                }
            }
            if ((blockEntity = BlockPreviewWidget.MINECRAFT.level.getBlockEntity(blockPos)) != null && (beRenderer = MINECRAFT.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                beRenderer.render(blockEntity, partialTick, guiGraphics.pose(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        }
        guiGraphics.pose().popPose();
    }

    private void renderSelection(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform) {
        if (this.selection.isEmpty()) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)centerX, (float)centerY, 100.0f);
        guiGraphics.pose().scale(this.scale, this.scale, -this.scale);
        guiGraphics.pose().mulPose(transform);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        TextureAtlasSprite tex = (TextureAtlasSprite)MINECRAFT.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(SELECTED_ICON);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex.atlasLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SelectedFace selectedFace = this.selection.get();
        BlockPos blockPos = selectedFace.blockPos;
        guiGraphics.pose().translate((float)blockPos.getX() - this.worldOrigin.x(), (float)blockPos.getY() - this.worldOrigin.y(), (float)blockPos.getZ() - this.worldOrigin.z());
        Vector3f[] vec = BlockPreviewWidget.createQuadVerts(selectedFace.side, 0.0f, 1.0f, 1.0f);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        bufferbuilder.addVertex(matrix4f, vec[0].x(), vec[0].y(), vec[0].z()).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getU0(), tex.getV0());
        bufferbuilder.addVertex(matrix4f, vec[1].x(), vec[1].y(), vec[1].z()).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getU0(), tex.getV1());
        bufferbuilder.addVertex(matrix4f, vec[2].x(), vec[2].y(), vec[2].z()).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getU1(), tex.getV1());
        bufferbuilder.addVertex(matrix4f, vec[3].x(), vec[3].y(), vec[3].z()).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getU1(), tex.getV0());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        guiGraphics.pose().popPose();
    }

    public static Vector3f[] createQuadVerts(Direction face, float leftEdge, float rightEdge, float elevation) {
        Vector3f[] vector3fArray;
        switch (face) {
            default: {
                throw new MatchException(null, null);
            }
            case DOWN: {
                Vector3f[] vector3fArray2 = new Vector3f[4];
                vector3fArray2[0] = new Vector3f(leftEdge, 1.0f - elevation, leftEdge);
                vector3fArray2[1] = new Vector3f(rightEdge, 1.0f - elevation, leftEdge);
                vector3fArray2[2] = new Vector3f(rightEdge, 1.0f - elevation, rightEdge);
                vector3fArray = vector3fArray2;
                vector3fArray2[3] = new Vector3f(leftEdge, 1.0f - elevation, rightEdge);
                break;
            }
            case UP: {
                Vector3f[] vector3fArray3 = new Vector3f[4];
                vector3fArray3[0] = new Vector3f(leftEdge, elevation, leftEdge);
                vector3fArray3[1] = new Vector3f(leftEdge, elevation, rightEdge);
                vector3fArray3[2] = new Vector3f(rightEdge, elevation, rightEdge);
                vector3fArray = vector3fArray3;
                vector3fArray3[3] = new Vector3f(rightEdge, elevation, leftEdge);
                break;
            }
            case NORTH: {
                Vector3f[] vector3fArray4 = new Vector3f[4];
                vector3fArray4[0] = new Vector3f(rightEdge, rightEdge, 1.0f - elevation);
                vector3fArray4[1] = new Vector3f(rightEdge, leftEdge, 1.0f - elevation);
                vector3fArray4[2] = new Vector3f(leftEdge, leftEdge, 1.0f - elevation);
                vector3fArray = vector3fArray4;
                vector3fArray4[3] = new Vector3f(leftEdge, rightEdge, 1.0f - elevation);
                break;
            }
            case SOUTH: {
                Vector3f[] vector3fArray5 = new Vector3f[4];
                vector3fArray5[0] = new Vector3f(leftEdge, rightEdge, elevation);
                vector3fArray5[1] = new Vector3f(leftEdge, leftEdge, elevation);
                vector3fArray5[2] = new Vector3f(rightEdge, leftEdge, elevation);
                vector3fArray = vector3fArray5;
                vector3fArray5[3] = new Vector3f(rightEdge, rightEdge, elevation);
                break;
            }
            case WEST: {
                Vector3f[] vector3fArray6 = new Vector3f[4];
                vector3fArray6[0] = new Vector3f(1.0f - elevation, rightEdge, leftEdge);
                vector3fArray6[1] = new Vector3f(1.0f - elevation, leftEdge, leftEdge);
                vector3fArray6[2] = new Vector3f(1.0f - elevation, leftEdge, rightEdge);
                vector3fArray = vector3fArray6;
                vector3fArray6[3] = new Vector3f(1.0f - elevation, rightEdge, rightEdge);
                break;
            }
            case EAST: {
                Vector3f[] vector3fArray7 = new Vector3f[4];
                vector3fArray7[0] = new Vector3f(elevation, rightEdge, rightEdge);
                vector3fArray7[1] = new Vector3f(elevation, leftEdge, rightEdge);
                vector3fArray7[2] = new Vector3f(elevation, leftEdge, leftEdge);
                vector3fArray = vector3fArray7;
                vector3fArray7[3] = new Vector3f(elevation, rightEdge, leftEdge);
            }
        }
        return vector3fArray;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> REMAPPED_TYPES = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original, "createadditionallogistics"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> {
                original.setupRenderState();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.clearRenderState();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return REMAPPED_TYPES.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class SolidRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> REMAPPED_TYPES = new IdentityHashMap<RenderType, RenderType>();

        private SolidRenderLayer(RenderType original) {
            super(String.format("%s_%s_solid", original, "createadditionallogistics"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> original.setupRenderState(), () -> original.clearRenderState());
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof SolidRenderLayer) {
                return in;
            }
            return REMAPPED_TYPES.computeIfAbsent(in, SolidRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        private GhostBuffers(ByteBufferBuilder fallback, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer getBuffer(RenderType type) {
            return super.getBuffer(GhostRenderLayer.remap(type));
        }
    }

    private static class SolidBuffers
    extends MultiBufferSource.BufferSource {
        private SolidBuffers(ByteBufferBuilder fallback, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer getBuffer(RenderType type) {
            return super.getBuffer(SolidRenderLayer.remap(type));
        }
    }

    private record SelectedFace(BlockPos blockPos, Direction side) {
    }
}

