/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blockentities;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.network.CustomPackets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLowEntityKineticBlockEntity
extends SplitShaftBlockEntity {
    @Nullable
    protected List<BlockPos> connections;
    @Nullable
    private List<BlockPos> pendingConnections;
    protected boolean checkInvalid;
    protected boolean lazyDirty;
    private static final Set<LevelBlockPos> dirtyPositions = new ObjectOpenHashSet();

    public AbstractLowEntityKineticBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.connections = null;
        if (compound.contains("Connected", 12)) {
            long[] cache = compound.getLongArray("Connected");
            this.connections = new ArrayList<BlockPos>(cache.length);
            for (long pos : cache) {
                this.connections.add(BlockPos.of((long)pos));
            }
        } else if (compound.contains("Connections", 12)) {
            this.lazyDirty = true;
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.connections != null) {
            long[] cache = new long[this.connections.size()];
            int i = 0;
            for (BlockPos entry : this.connections) {
                cache[i] = entry.asLong();
                ++i;
            }
            compound.putLongArray("Connected", cache);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.lazyDirty) {
                this.lazyDirty = false;
                AbstractLowEntityKineticBlockEntity.markDirty(this.level, this.worldPosition);
            }
            if (this.checkInvalid) {
                this.checkInvalid = false;
                this.removeInvalidConnections();
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.notifyConnectedToValidate();
    }

    public void removeInvalidConnections() {
        boolean changed = false;
        if (this.connections != null) {
            Iterator<BlockPos> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                BlockPos relative = this.worldPosition.offset((Vec3i)pos);
                if (!this.level.isLoaded(relative) || this.level.getBlockEntity(relative) instanceof AbstractLowEntityKineticBlockEntity) continue;
                iterator.remove();
                changed = true;
            }
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    public void notifyConnectedToValidate() {
        if (this.connections != null && this.level != null) {
            for (BlockPos pos : this.connections) {
                BlockEntity blockEntity;
                BlockPos relative = this.worldPosition.offset((Vec3i)pos);
                if (!this.level.isLoaded(relative) || !((blockEntity = this.level.getBlockEntity(relative)) instanceof AbstractLowEntityKineticBlockEntity)) continue;
                AbstractLowEntityKineticBlockEntity lek = (AbstractLowEntityKineticBlockEntity)blockEntity;
                lek.checkInvalid = true;
            }
        }
    }

    public boolean isValidBlockState(BlockState state) {
        AbstractLowEntityKineticBlock lek;
        Block block = state.getBlock();
        return block instanceof AbstractLowEntityKineticBlock && (lek = (AbstractLowEntityKineticBlock)block).isActive(state);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (this.connections != null) {
            this.connections.forEach(p -> {
                BlockPos pos = this.worldPosition.offset((Vec3i)p);
                if (!neighbours.contains(pos)) {
                    neighbours.add(pos);
                }
            });
        }
        if (!ICogWheel.isLargeCog((BlockState)state)) {
            return super.addPropagationLocations(block, state, neighbours);
        }
        BlockPos.betweenClosedStream((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (offset.distSqr((Vec3i)BlockPos.ZERO) == 2.0) {
                neighbours.add(this.worldPosition.offset((Vec3i)offset));
            }
        });
        return neighbours;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof AbstractLowEntityKineticBlockEntity && this.connections != null && this.connections.contains(target.getBlockPos().subtract((Vec3i)this.worldPosition))) {
            return 1.0f;
        }
        return 0.0f;
    }

    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        BlockPos relative = other.getBlockPos().subtract((Vec3i)this.worldPosition);
        return this.connections != null && this.connections.contains(relative);
    }

    protected boolean setConnections(List<BlockPos> newConnections) {
        boolean contains_next;
        int index;
        for (index = 0; index < newConnections.size() && !this.worldPosition.equals((Object)newConnections.get(index)); ++index) {
        }
        if (index >= newConnections.size()) {
            return false;
        }
        int previous = index - 1;
        int next = index + 1;
        if (this.connections == null) {
            this.connections = new ArrayList<BlockPos>();
        }
        @Nullable BlockPos prevPos = previous == -1 ? null : newConnections.get(previous).subtract((Vec3i)this.worldPosition);
        @Nullable BlockPos nextPos = next >= newConnections.size() ? null : newConnections.get(next).subtract((Vec3i)this.worldPosition);
        int count = (prevPos == null ? 0 : 1) + (nextPos == null ? 0 : 1);
        boolean contains_previous = prevPos == null || this.connections.contains(prevPos);
        boolean bl = contains_next = nextPos == null || this.connections.contains(nextPos);
        if (contains_previous && contains_next && this.connections.size() == count) {
            return false;
        }
        this.detachKinetics();
        this.pendingConnections = new ArrayList<BlockPos>();
        if (prevPos != null) {
            this.pendingConnections.add(prevPos);
        }
        if (nextPos != null) {
            this.pendingConnections.add(nextPos);
        }
        return true;
    }

    protected void finalizeConnections() {
        if (this.pendingConnections == null) {
            return;
        }
        this.connections = this.pendingConnections;
        this.pendingConnections = null;
        this.notifyUpdate();
        this.updateSpeed = true;
    }

    public static WalkResult walkBlocks(Level level, BlockPos pos) {
        return AbstractLowEntityKineticBlockEntity.walkBlocks(level, pos, Integer.MAX_VALUE);
    }

    public static WalkResult walkBlocks(Level level, BlockPos pos, int limit) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof AbstractLowEntityKineticBlock)) {
            return WalkResult.EMPTY;
        }
        AbstractLowEntityKineticBlock block2 = (AbstractLowEntityKineticBlock)block;
        ObjectOpenHashSet visited = new ObjectOpenHashSet();
        TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity> entities = new TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity>(Vec3i::compareTo);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        visited.add(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractLowEntityKineticBlockEntity) {
            AbstractLowEntityKineticBlockEntity lek = (AbstractLowEntityKineticBlockEntity)blockEntity;
            entities.put(pos, lek);
            if (entities.size() >= limit) {
                return new WalkResult((Set<BlockPos>)visited, entities);
            }
        }
        AbstractLowEntityKineticBlockEntity.addToDirtyList(level, pos, state, block2, (Set<BlockPos>)visited, queue);
        while (!queue.isEmpty()) {
            BlockState qstate;
            Block block3;
            BlockPos qpos = (BlockPos)queue.removeFirst();
            if (!level.isLoaded(qpos) || !((block3 = (qstate = level.getBlockState(qpos)).getBlock()) instanceof AbstractLowEntityKineticBlock)) continue;
            AbstractLowEntityKineticBlock qblock = (AbstractLowEntityKineticBlock)block3;
            BlockEntity blockEntity2 = level.getBlockEntity(qpos);
            if (blockEntity2 instanceof AbstractLowEntityKineticBlockEntity) {
                AbstractLowEntityKineticBlockEntity qlek = (AbstractLowEntityKineticBlockEntity)blockEntity2;
                entities.put(qpos, qlek);
                if (entities.size() >= limit) {
                    return new WalkResult((Set<BlockPos>)visited, entities);
                }
            }
            AbstractLowEntityKineticBlockEntity.addToDirtyList(level, qpos, qstate, qblock, (Set<BlockPos>)visited, queue);
        }
        return new WalkResult((Set<BlockPos>)visited, entities);
    }

    private static void addToDirtyList(Level world, BlockPos pos, BlockState state, AbstractLowEntityKineticBlock<?> block, Set<BlockPos> visited, List<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p = pos.relative(direction);
            if (visited.contains(p) || !world.isLoaded(p) || !block.connectsTo((LevelAccessor)world, pos, state, direction, p, world.getBlockState(p))) continue;
            visited.add(p);
            queue.add(p);
        }
    }

    public static void markDirty(Level level, BlockPos pos) {
        if (level.isClientSide) {
            AbstractLowEntityKineticBlock.clearInformationWalkCache();
            return;
        }
        dirtyPositions.add(new LevelBlockPos(level, pos));
    }

    public static void updateDirty() {
        LinkedList<LevelBlockPos> dirty = new LinkedList<LevelBlockPos>(dirtyPositions);
        dirtyPositions.clear();
        ArrayList<AbstractLowEntityKineticBlockEntity> toFinalize = new ArrayList<AbstractLowEntityKineticBlockEntity>();
        ObjectOpenHashSet levels = new ObjectOpenHashSet();
        while (!dirty.isEmpty()) {
            LevelBlockPos pos = dirty.removeFirst();
            WalkResult result = AbstractLowEntityKineticBlockEntity.walkBlocks(pos.level, pos.pos);
            Level level = pos.level;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                levels.add(sl);
            }
            if (!result.entities.isEmpty()) {
                List<BlockPos> entityPositions = result.entities.navigableKeySet().stream().toList();
                for (AbstractLowEntityKineticBlockEntity entity : result.entities.values()) {
                    if (!entity.setConnections(entityPositions)) continue;
                    toFinalize.add(entity);
                }
            }
            if (result.visited.isEmpty()) continue;
            dirty.removeIf(x -> result.visited.contains(x.pos));
        }
        for (AbstractLowEntityKineticBlockEntity entity : toFinalize) {
            entity.finalizeConnections();
        }
        for (ServerLevel level : levels) {
            CustomPackets.ServerToClientEvent.CLEAR_INFORMATION.send(level);
        }
    }

    public static void onTick(ServerTickEvent.Post event) {
        if (!dirtyPositions.isEmpty()) {
            AbstractLowEntityKineticBlockEntity.updateDirty();
        }
    }

    public record WalkResult(Set<BlockPos> visited, TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity> entities) {
        public static WalkResult EMPTY = new WalkResult(Collections.emptySet(), new TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity>());
    }

    private record LevelBlockPos(Level level, BlockPos pos) {
    }
}

