/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.khloeleclair.create.additionallogistics.common.blockentities.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.blocks.FlexibleShaftBlock;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazyShaftBlock<T extends AbstractLowEntityKineticBlockEntity>
extends AbstractLowEntityKineticBlock<T>
implements EncasableBlock,
ProperWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty NEGATIVE = BooleanProperty.create((String)"negative");
    public static final BooleanProperty POSITIVE = BooleanProperty.create((String)"positive");

    public AbstractLazyShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = this.defaultBlockState();
        if (state.hasProperty((Property)WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)NEGATIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)POSITIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState copyValuesForCasing(BlockState from, BlockState to) {
        if (from.hasProperty((Property)WATERLOGGED) && to.hasProperty((Property)WATERLOGGED)) {
            to = (BlockState)to.setValue((Property)WATERLOGGED, (Comparable)((Boolean)from.getValue((Property)WATERLOGGED)));
        }
        if (from.hasProperty(AXIS) && to.hasProperty(AXIS)) {
            to = (BlockState)to.setValue(AXIS, (Comparable)((Direction.Axis)from.getValue(AXIS)));
        }
        if (from.hasProperty((Property)POSITIVE) && to.hasProperty((Property)POSITIVE)) {
            to = (BlockState)to.setValue((Property)POSITIVE, (Comparable)((Boolean)from.getValue((Property)POSITIVE)));
        }
        if (from.hasProperty((Property)NEGATIVE) && to.hasProperty((Property)NEGATIVE)) {
            to = (BlockState)to.setValue((Property)NEGATIVE, (Comparable)((Boolean)from.getValue((Property)NEGATIVE)));
        }
        return to;
    }

    public FluidState fluidState(BlockState state) {
        if (!state.hasProperty((Property)WATERLOGGED)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return super.fluidState(state);
    }

    public void updateWater(LevelAccessor level, BlockState state, BlockPos pos) {
        if (state.hasProperty((Property)WATERLOGGED)) {
            super.updateWater(level, state, pos);
        }
    }

    public BlockState withWater(BlockState placementState, BlockPlaceContext ctx) {
        if (placementState.hasProperty((Property)WATERLOGGED)) {
            return super.withWater(placementState, ctx);
        }
        return placementState;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (!(oldState.getBlock() instanceof AbstractLazyShaftBlock) || !(newState.getBlock() instanceof AbstractLazyShaftBlock)) {
            return false;
        }
        if (!oldState.hasProperty(AXIS) || !newState.hasProperty(AXIS)) {
            return false;
        }
        return oldState.getValue(AXIS) == newState.getValue(AXIS);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        byte key = 0;
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean positive = (Boolean)state.getValue((Property)POSITIVE);
        boolean negative = (Boolean)state.getValue((Property)NEGATIVE);
        if (positive) {
            key = (byte)(key | 1 << Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).ordinal());
        }
        if (negative) {
            key = (byte)(key | 1 << Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).ordinal());
        }
        return this.getShapeWithSides(key);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockState withSides(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        Direction positive = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction negative = positive.getOpposite();
        state = (BlockState)state.setValue((Property)POSITIVE, (Comparable)Boolean.valueOf(this.connectsTo(level, pos, state, positive)));
        state = (BlockState)state.setValue((Property)NEGATIVE, (Comparable)Boolean.valueOf(this.connectsTo(level, pos, state, negative)));
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS, POSITIVE, NEGATIVE});
        if (!(this instanceof EncasedBlock)) {
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    @Nullable
    public static Direction.Axis getPreferredAxis(BlockPlaceContext context) {
        Direction.Axis preferredAxis = null;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction side : Iterate.directions) {
            IRotate rot;
            Direction.Axis axis = side.getAxis();
            BlockPos newPos = pos.relative(side);
            BlockState newState = level.getBlockState(newPos);
            Block newBlock = newState.getBlock();
            if (newBlock instanceof FlexibleShaftBlock) {
                if (context.getClickedFace() == side.getOpposite()) {
                    return axis;
                }
                if (preferredAxis != null && preferredAxis != axis) {
                    preferredAxis = null;
                    break;
                }
                preferredAxis = axis;
            }
            if (!(newBlock instanceof IRotate) || !(rot = (IRotate)newBlock).hasShaftTowards((LevelReader)level, newPos, newState, side.getOpposite())) continue;
            if (context.getClickedFace() == side.getOpposite()) {
                return axis;
            }
            if (preferredAxis != null && preferredAxis != axis) {
                preferredAxis = null;
                break;
            }
            preferredAxis = axis;
        }
        return preferredAxis;
    }

    @Nullable
    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        return AbstractLazyShaftBlock.getPreferredAxis(context);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        BlockState newState = this.withSides(level, pos, state);
        if (newState != state && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return newState;
    }

    protected FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis preferred = this.getAxisForPlacement(context);
        BlockState state = preferred != null && (context.getPlayer() != null || !context.getPlayer().isShiftKeyDown()) ? (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)preferred) : (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)(preferred != null && context.getPlayer().isShiftKeyDown() ? context.getClickedFace().getAxis() : context.getNearestLookingDirection().getAxis()));
        return this.withWater(this.withSides((LevelAccessor)context.getLevel(), context.getClickedPos(), state), context);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.getAxis() != state.getValue(AXIS)) {
            return false;
        }
        Direction.AxisDirection dir = face.getAxisDirection();
        if (dir == Direction.AxisDirection.POSITIVE) {
            return (Boolean)state.getValue((Property)POSITIVE) == false;
        }
        return (Boolean)state.getValue((Property)NEGATIVE) == false;
    }

    @Override
    protected boolean shouldConnectImpl(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        if (direction.getAxis() != state.getValue(AXIS)) {
            return false;
        }
        return super.shouldConnectImpl(level, pos, state, direction, otherPos, otherState);
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)NEGATIVE) == false || (Boolean)state.getValue((Property)POSITIVE) == false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue(AXIS);
    }
}

