/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlock;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blockentities.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CashRegisterBlock
extends StockTickerBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final MapCodec<CashRegisterBlock> CODEC = CashRegisterBlock.simpleCodec(CashRegisterBlock::new);
    public static VoxelShape[] SHAPES = new VoxelShape[Iterate.horizontalDirections.length];

    public CashRegisterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN});
    }

    public static VoxelShape buildShape(Direction facing) {
        double x2;
        double z1;
        double x1;
        return Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (VoxelShape)Shapes.box((double)x1, (double)0.375, (double)z1, (double)x2, (double)1.0, (double)(switch (facing) {
            case Direction.NORTH -> {
                x1 = 0.0;
                z1 = 0.625;
                x2 = 1.0;
                yield 1.0;
            }
            case Direction.EAST -> {
                x1 = 0.0;
                z1 = 0.0;
                x2 = 0.375;
                yield 1.0;
            }
            case Direction.WEST -> {
                x1 = 0.625;
                z1 = 0.0;
                x2 = 1.0;
                yield 1.0;
            }
            default -> {
                x1 = 0.0;
                z1 = 0.0;
                x2 = 1.0;
                yield 0.375;
            }
        })));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[((Direction)pState.getValue((Property)FACING)).get2DDataValue() % SHAPES.length];
    }

    public BlockEntityType<? extends StockTickerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.CASH_REGISTER.get();
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity cbe = (CashRegisterBlockEntity)blockEntity;
            cbe.recheckOpen();
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof LogisticallyLinkedBlockItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CashRegisterBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CashRegisterBlockEntity be = (CashRegisterBlockEntity)blockEntity;
        if (!be.behaviour.mayInteractMessage(player)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu((MenuProvider)be.new CashRegisterBlockEntity.CashRegisterMenuProvider(), be.getBlockPos());
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        for (int i = 0; i < SHAPES.length; ++i) {
            Direction dir = Iterate.horizontalDirections[i];
            CashRegisterBlock.SHAPES[i] = CashRegisterBlock.buildShape(dir);
        }
    }
}

