/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.khloeleclair.create.additionallogistics.common.blockentities.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blockentities.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.network.CustomPackets;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.mixin.RotationPropagatorInvoker;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlexibleShaftBlock
extends AbstractLowEntityKineticBlock<FlexibleShaftBlockEntity>
implements EncasableBlock,
ProperWaterloggedBlock {
    public static final BooleanProperty[] SIDES = new BooleanProperty[]{BooleanProperty.create((String)"down"), BooleanProperty.create((String)"up"), BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    @Nullable
    protected final DyeColor color;

    public FlexibleShaftBlock(BlockBehaviour.Properties properties) {
        this(properties, null);
    }

    public FlexibleShaftBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color) {
        super(properties);
        this.color = color;
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        if (state.hasProperty((Property)WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        for (BooleanProperty side : SIDES) {
            state = (BlockState)state.setValue((Property)side, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add((Property[])SIDES);
        builder.add(new Property[]{ACTIVE});
        if (!(this instanceof EncasedBlock)) {
            builder.add(new Property[]{WATERLOGGED});
        }
    }

    public FluidState fluidState(BlockState state) {
        if (!state.hasProperty((Property)WATERLOGGED)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return super.fluidState(state);
    }

    public void updateWater(LevelAccessor level, BlockState state, BlockPos pos) {
        if (state.hasProperty((Property)WATERLOGGED)) {
            super.updateWater(level, state, pos);
        }
    }

    public BlockState withWater(BlockState placementState, BlockPlaceContext ctx) {
        if (placementState.hasProperty((Property)WATERLOGGED)) {
            return super.withWater(placementState, ctx);
        }
        return placementState;
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE);
    }

    @Override
    @Nullable
    DyeColor getColor(BlockState state) {
        return this.color;
    }

    protected FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    protected BlockState getConnectedState(Level level, BlockPos pos, BlockState initialState) {
        BlockState state = initialState;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            BlockPos dpos = pos.relative(dir);
            BlockState dstate = level.getBlockState(dpos);
            boolean connects = this.connectsTo((LevelAccessor)level, pos, state, dir, dpos, dstate);
            state = (BlockState)state.setValue((Property)SIDES[index], (Comparable)Boolean.valueOf(connects));
        }
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.getConnectedState(level, pos, super.getStateForPlacement(context));
        return this.withWater(state, context);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        byte key = 0;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            if (!((Boolean)state.getValue((Property)SIDES[index])).booleanValue()) continue;
            key = (byte)(key | 1 << index);
        }
        return this.getShapeWithSides(key);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        BooleanProperty prop = SIDES[direction.ordinal()];
        boolean connects = this.connectsTo(level, pos, state, direction, neighborPos, level.getBlockState(neighborPos));
        if ((Boolean)state.getValue((Property)prop) != connects && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(connects));
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return state;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        BlockEntity blockEntity;
        if (!this.isActive(state) || !((blockEntity = world.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity)) {
            return false;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        return fsb.getSide(face) != 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getMainHandItem().isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CustomPackets.OpenFlexibleShaftScreen.of(pos).send(sp);
        }
        return InteractionResult.SUCCESS;
    }

    public void setSide(Level level, BlockPos pos, Direction side, byte value) {
        BlockEntity blockEntity;
        if (level.isClientSide || !level.isLoaded(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (value == 0) {
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.getBlockEntity(pos)) instanceof FlexibleShaftBlockEntity)) {
            return;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        fsb.setSide(side, value);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IRotate rot;
        BlockPos offsetPos;
        BlockState offsetState;
        Block block;
        BlockEntity blockEntity;
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction side = context.getClickedFace();
        if (((Boolean)state.getValue((Property)SIDES[side.ordinal()])).booleanValue() && !(this instanceof EncasedBlock)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof FlexibleShaftBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        byte mode = fsb.getSide(side);
        if (mode == 0 && (block = (offsetState = level.getBlockState(offsetPos = pos.relative(side))).getBlock()) instanceof IRotate && (rot = (IRotate)block).hasShaftTowards((LevelReader)level, offsetPos, offsetState, side.getOpposite()) && (block = level.getBlockEntity(offsetPos)) instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)block;
            fsb.setSideUnsafe(side, (byte)1);
            float neighborSpeed = kbe.getTheoreticalSpeed();
            float newSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            float oppositeSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            if (newSpeed != 0.0f && oppositeSpeed != 0.0f) {
                boolean incompatible;
                boolean bl = incompatible = Math.signum(newSpeed) != Math.signum(neighborSpeed) && newSpeed != 0.0f && neighborSpeed != 0.0f;
                if (incompatible) {
                    fsb.setSide(side, (byte)-1);
                    return InteractionResult.SUCCESS;
                }
            }
            fsb.setSideUnsafe(side, mode);
        }
        fsb.toggleSide(side);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
        return InteractionResult.SUCCESS;
    }

    public Class<FlexibleShaftBlockEntity> getBlockEntityClass() {
        return FlexibleShaftBlockEntity.class;
    }

    public BlockEntityType<? extends FlexibleShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.FLEXIBLE_SHAFT.get();
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> {
                Item patt0$temp = i.getItem();
                if (!(patt0$temp instanceof BlockItem)) {
                    return false;
                }
                BlockItem bi = (BlockItem)patt0$temp;
                return bi.getBlock() instanceof FlexibleShaftBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof FlexibleShaftBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.getLocation(), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative((Direction)directions.getFirst()), s -> s);
        }
    }
}

