/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import dev.khloeleclair.create.additionallogistics.common.blockentities.LazyCogWheelBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLazyShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LazyCogWheelBlock
extends AbstractLazyShaftBlock<LazyCogWheelBlockEntity>
implements ICogWheel {
    boolean isLarge;

    public LazyCogWheelBlock(boolean large, BlockBehaviour.Properties properties) {
        super(properties);
        this.isLarge = large;
    }

    public static LazyCogWheelBlock small(BlockBehaviour.Properties properties) {
        return new LazyCogWheelBlock(false, properties);
    }

    public static LazyCogWheelBlock large(BlockBehaviour.Properties properties) {
        return new LazyCogWheelBlock(true, properties);
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.getShape(state, level, pos, context);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.isClientSide || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.relative(d1, offset1).relative(d2, offset2);
                        BlockState blockState = world.getBlockState(connectedPos);
                        if (!(blockState.getBlock() instanceof CogWheelBlock) || blockState.getValue((Property)CogWheelBlock.AXIS) != axis || ICogWheel.isLargeCog((BlockState)blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return null;
    }

    @Override
    @Nullable
    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            return context.getClickedFace().getAxis();
        }
        Level world = context.getLevel();
        BlockPos placedOnPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockState placedAgainst = world.getBlockState(placedOnPos);
        Block block = placedAgainst.getBlock();
        if (ICogWheel.isSmallCog((BlockState)placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = LazyCogWheelBlock.getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.getClickedFace().getAxis();
    }

    public float getParticleTargetRadius() {
        return this.isLarge ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLarge ? 1.0f : 0.75f;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    @Override
    @Nullable
    DyeColor getColor(BlockState state) {
        return null;
    }

    @Override
    public boolean isActive(BlockState state) {
        return true;
    }

    public Class<LazyCogWheelBlockEntity> getBlockEntityClass() {
        return LazyCogWheelBlockEntity.class;
    }

    public BlockEntityType<? extends LazyCogWheelBlockEntity> getBlockEntityType() {
        return this.isLarge ? (BlockEntityType)CALBlockEntityTypes.LAZY_LARGE_COGWHEEL.get() : (BlockEntityType)CALBlockEntityTypes.LAZY_COGWHEEL.get();
    }
}

