/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.simibubi.create.foundation.placement.PoleHelper;
import dev.khloeleclair.create.additionallogistics.common.blockentities.LazyShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLazyShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.blocks.FlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LazyShaftBlock
extends AbstractLazyShaftBlock<LazyShaftBlockEntity> {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final VoxelShape[] CONNECTOR_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0)};

    public LazyShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        boolean positive = (Boolean)state.getValue((Property)POSITIVE);
        boolean negative = (Boolean)state.getValue((Property)NEGATIVE);
        if (positive && negative) {
            if (axis == Direction.Axis.X) {
                return CONNECTOR_SHAPES[0];
            }
            if (axis == Direction.Axis.Y) {
                return CONNECTOR_SHAPES[1];
            }
            return CONNECTOR_SHAPES[2];
        }
        return super.getShape(state, level, pos, context);
    }

    @Override
    @Nullable
    DyeColor getColor(BlockState state) {
        return null;
    }

    public Class<LazyShaftBlockEntity> getBlockEntityClass() {
        return LazyShaftBlockEntity.class;
    }

    public BlockEntityType<? extends LazyShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.LAZY_SHAFT.get();
    }

    @Override
    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return PlacementHelpers.get((int)placementHelperId);
    }

    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.getBlock() instanceof LazyShaftBlock, state -> (Direction.Axis)state.getValue(AbstractLazyShaftBlock.AXIS), AbstractLazyShaftBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.getItem() instanceof BlockItem && ((BlockItem)i.getItem()).getBlock() instanceof LazyShaftBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> {
                if (s.getBlock() instanceof LazyShaftBlock) {
                    return true;
                }
                return s.getBlock() instanceof FlexibleShaftBlock;
            };
        }

        public PlacementOffset getOffsetFlexible(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.getLocation());
            Direction side = (Direction)directions.getFirst();
            BlockPos newPos = pos.relative(side);
            BlockState newState = world.getBlockState(newPos);
            if (newState.canBeReplaced()) {
                return PlacementOffset.success((Vec3i)newPos, b -> (BlockState)b.setValue(AbstractLazyShaftBlock.AXIS, (Comparable)side.getAxis()));
            }
            return PlacementOffset.fail();
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset;
            PlacementOffset placementOffset = offset = state.getBlock() instanceof FlexibleShaftBlock ? this.getOffsetFlexible(player, world, state, pos, ray) : super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> world.isClientSide() ? s : ((LazyShaftBlock)s.getBlock()).withSides((LevelAccessor)world, offset.getBlockPos(), (BlockState)s)));
            }
            return offset;
        }
    }
}

