/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.entities;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractSeatBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALEntityTypes;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CustomSeatEntity
extends SeatEntity {
    public CustomSeatEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CustomSeatEntity(Level world, BlockPos pos) {
        super((EntityType)CALEntityTypes.CUSTOM_SEAT.get(), world);
        this.noPhysics = true;
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected void positionRider(Entity pEntity, Entity.MoveFunction pCallback) {
        double heightOffset = this.getY() - pEntity.getVehicleAttachmentPoint((Entity)this).y;
        pCallback.accept(pEntity, this.getX(), heightOffset + CustomSeatEntity.getCustomEntitySeatOffset(pEntity), this.getZ());
    }

    public static double getCustomEntitySeatOffset(Entity passenger) {
        Block block;
        double result = SeatEntity.getCustomEntitySeatOffset((Entity)passenger);
        Entity entity = passenger.getVehicle();
        if (!(entity instanceof AbstractContraptionEntity)) {
            return result;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        if (!contraptionEntity.hasPassenger(passenger)) {
            return result;
        }
        BlockPos seatPos = contraption.getSeatOf(passenger.getUUID());
        StructureTemplate.StructureBlockInfo block2 = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(seatPos);
        if (block2 == null) {
            return result;
        }
        BlockState state = block2.state();
        if (state != null && (block = state.getBlock()) instanceof AbstractSeatBlock) {
            AbstractSeatBlock seat = (AbstractSeatBlock)block;
            Vec3 offset = seat.getSeatPosition(null, BlockPos.ZERO);
            result += offset.y - 0.5;
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Render
    extends EntityRenderer<CustomSeatEntity> {
        public Render(EntityRendererProvider.Context context) {
            super(context);
        }

        public boolean shouldRender(CustomSeatEntity p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
            return false;
        }

        public ResourceLocation getTextureLocation(CustomSeatEntity p_110775_1_) {
            return null;
        }
    }
}

