/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.items;

import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.data.CustomComponents;
import dev.khloeleclair.create.additionallogistics.common.data.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.network.CustomPackets;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SalesLedgerItem
extends Item {
    public SalesLedgerItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SalesHistoryData data = (SalesHistoryData)stack.get(CustomComponents.SALES_HISTORY);
        if (data == null) {
            return;
        }
        tooltipComponents.add((Component)CALLang.translate("sales.entries", CALLang.number(data.saleCount()).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).component());
        MutableComponent cmp = data.getTimeRange(ChatFormatting.AQUA);
        if (cmp != null) {
            tooltipComponents.add((Component)cmp.withStyle(ChatFormatting.GRAY));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) != 0;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getDamage(ItemStack stack) {
        SalesHistoryData history = (SalesHistoryData)stack.get(CustomComponents.SALES_HISTORY);
        return history == null ? 0 : history.saleCount();
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!level.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CustomPackets.OpenSalesLedgerScreen.create(heldItem).ifPresent(p -> p.send(sp));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }
}

