/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.khloeleclair.create.additionallogistics.common.blockentities.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blockentities.PackageEditorBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.data.CustomComponents;
import dev.khloeleclair.create.additionallogistics.common.data.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSalesHistoryObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.CashRegisterPeripheral;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.PackageEditorPeripheral;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;

public class CALComputerBehavior
extends AbstractComputerBehaviour {
    IPeripheral peripheral;
    Supplier<IPeripheral> peripheralSupplier;

    public CALComputerBehavior(SmartBlockEntity sbe) {
        super(sbe);
        this.peripheralSupplier = CALComputerBehavior.getPeripheralFor(sbe);
    }

    public static Supplier<IPeripheral> getPeripheralFor(SmartBlockEntity sbe) {
        if (sbe instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity cr = (CashRegisterBlockEntity)sbe;
            return () -> new CashRegisterPeripheral(cr);
        }
        if (sbe instanceof PackageEditorBlockEntity) {
            PackageEditorBlockEntity pe = (PackageEditorBlockEntity)sbe;
            return () -> new PackageEditorPeripheral(pe);
        }
        throw new IllegalArgumentException("No peripheral available for " + String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)sbe.getType())));
    }

    public static void registerItemDetailProviders() {
        VanillaDetailRegistries.ITEM_STACK.addProvider((out, stack) -> {
            if (stack.is(CALItems.SALES_LEDGER)) {
                LuaSalesHistoryObject obj = new LuaSalesHistoryObject((SalesHistoryData)stack.get(CustomComponents.SALES_HISTORY));
                out.put("sales", obj);
            }
        });
    }

    public IPeripheral getPeripheralCapability() {
        if (this.peripheral == null) {
            this.peripheral = this.peripheralSupplier.get();
        }
        return this.peripheral;
    }

    public void removePeripheral() {
        if (this.peripheral != null) {
            this.getWorld().invalidateCapabilities(this.blockEntity.getBlockPos());
        }
    }
}

