/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.IPromiseLimit;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class})
public class MixinFactoryPanelBehaviour
extends FilteringBehaviour
implements IPromiseLimit {
    private static final String PROMISE_LIMIT_KEY = "CAL$PromiseLimit";
    private int promiseLimit = -1;

    public MixinFactoryPanelBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    @Override
    public boolean hasPromiseLimit() {
        return this.promiseLimit >= 0 && (Boolean)Config.Common.enablePromiseLimits.get() != false;
    }

    @Override
    public int getPromiseLimit() {
        return this.promiseLimit;
    }

    @Override
    public void setPromiseLimit(int value) {
        if (value < 0) {
            value = -1;
        }
        this.promiseLimit = value;
    }

    private FactoryPanelBehaviour FPB() {
        return (FactoryPanelBehaviour)this;
    }

    private void writePromiseLimit(CompoundTag nbt) {
        FactoryPanelBehaviour fpb = this.FPB();
        if (!fpb.active) {
            return;
        }
        String tagName = CreateLang.asId((String)fpb.slot.name());
        CompoundTag tag = nbt.getCompound(tagName);
        tag.putInt(PROMISE_LIMIT_KEY, this.promiseLimit);
        nbt.put(tagName, (Tag)tag);
    }

    @Inject(method={"tryRestock"}, at={@At(value="INVOKE_ASSIGN", target="Lorg/joml/Math;clamp(III)I")}, cancellable=true)
    private void CAL$onTryRestock(CallbackInfo ci, @Local(ordinal=2) int promised, @Local(ordinal=5) LocalIntRef amountToOrder) {
        if (!this.hasPromiseLimit()) {
            return;
        }
        int limit = this.getPromiseLimit();
        int amount = amountToOrder.get();
        if (promised + amount > limit) {
            amount = limit - promised;
        }
        if (amount <= 0) {
            ci.cancel();
        } else {
            amountToOrder.set(amount);
        }
    }

    @Inject(method={"tickRequests"}, at={@At(value="INVOKE", target="resetTimer", shift=At.Shift.AFTER)}, cancellable=true)
    private void CAL$inTickRequests(CallbackInfo ci) {
        if (!this.hasPromiseLimit()) {
            return;
        }
        FactoryPanelBehaviour fpb = this.FPB();
        int limit = this.getPromiseLimit();
        if (!fpb.panelBE().restocker) {
            limit *= fpb.recipeOutput;
        }
        if (limit <= 0 || fpb.getPromised() >= limit) {
            ci.cancel();
        }
    }

    @Inject(method={"writeSafe"}, at={@At(value="RETURN")})
    private void CAL$onWriteSafe(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        this.writePromiseLimit(nbt);
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void CAL$onWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        this.writePromiseLimit(nbt);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void CAL$onRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        FactoryPanelBehaviour fpb = this.FPB();
        if (!fpb.active) {
            return;
        }
        CompoundTag tag = nbt.getCompound(CreateLang.asId((String)fpb.slot.name()));
        if (tag.contains(PROMISE_LIMIT_KEY, 3)) {
            this.setPromiseLimit(tag.getInt(PROMISE_LIMIT_KEY));
        } else {
            this.setPromiseLimit(-1);
        }
    }
}

