/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.ct;

import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import dev.khloeleclair.create.additionallogistics.common.blocks.AbstractLazyShaftBlock;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EncasedLazyCogCTBehavior
extends EncasedCTBehaviour {
    @Nullable
    private final Couple<CTSpriteShiftEntry> sideShifts;
    private final boolean large;

    public EncasedLazyCogCTBehavior(CTSpriteShiftEntry shift) {
        this(shift, null);
    }

    public EncasedLazyCogCTBehavior(CTSpriteShiftEntry shift, @Nullable Couple<CTSpriteShiftEntry> sideShifts) {
        super(shift);
        this.large = sideShifts == null;
        this.sideShifts = sideShifts;
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AbstractLazyShaftBlock.AXIS);
        if (this.large || axis == face.getAxis()) {
            return super.connectsTo(state, other, reader, pos, otherPos, face);
        }
        if (other.getBlock() == state.getBlock() && other.getValue(AbstractLazyShaftBlock.AXIS) == state.getValue(AbstractLazyShaftBlock.AXIS)) {
            return true;
        }
        BlockState blockState = reader.getBlockState(otherPos.relative(face));
        if (!ICogWheel.isLargeCog((BlockState)blockState)) {
            return false;
        }
        return ((IRotate)blockState.getBlock()).getRotationAxis(blockState) == axis;
    }

    protected boolean reverseUVs(BlockState state, Direction face) {
        return ((Direction.Axis)state.getValue(AbstractLazyShaftBlock.AXIS)).isHorizontal() && face.getAxis().isHorizontal() && face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
    }

    protected boolean reverseUVsVertically(BlockState state, Direction face) {
        if (!this.large && state.getValue(AbstractLazyShaftBlock.AXIS) == Direction.Axis.X && face.getAxis() == Direction.Axis.Z) {
            return face != Direction.SOUTH;
        }
        return super.reverseUVsVertically(state, face);
    }

    protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
        if (this.large) {
            return super.reverseUVsHorizontally(state, face);
        }
        if (((Direction.Axis)state.getValue(AbstractLazyShaftBlock.AXIS)).isVertical() && face.getAxis().isHorizontal()) {
            return true;
        }
        if (state.getValue(AbstractLazyShaftBlock.AXIS) == Direction.Axis.Z && face == Direction.DOWN) {
            return true;
        }
        return super.reverseUVsHorizontally(state, face);
    }

    public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AbstractLazyShaftBlock.AXIS);
        if (this.large || axis == direction.getAxis()) {
            if (axis == direction.getAxis() && !((Boolean)state.getValue((Property)(direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? AbstractLazyShaftBlock.POSITIVE : AbstractLazyShaftBlock.NEGATIVE))).booleanValue()) {
                return null;
            }
            return super.getShift(state, direction, sprite);
        }
        return (CTSpriteShiftEntry)this.sideShifts.get(axis == Direction.Axis.X || axis == Direction.Axis.Z && direction.getAxis() == Direction.Axis.X);
    }
}

