/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blocks;

import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import dev.khloeleclair.create.additionallogistics.common.blockentities.AbstractLowEntityKineticBlockEntity;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLowEntityKineticBlock<T extends AbstractLowEntityKineticBlockEntity>
extends KineticBlock
implements IBE<T>,
IProxyHoveringInformation {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape[] SIDE_SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0), Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0), Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0)};
    protected static final Map<Byte, VoxelShape> SHAPE_CACHE = new Byte2ObjectOpenHashMap();
    @Nullable
    private static AbstractLowEntityKineticBlockEntity.WalkResult informationWalkResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VoxelShape getShapeWithSides(byte key) {
        VoxelShape cached;
        Map<Byte, VoxelShape> object = SHAPE_CACHE;
        synchronized (object) {
            cached = SHAPE_CACHE.get(key);
        }
        if (cached == null) {
            cached = SHAPE;
            for (Direction dir : Iterate.directions) {
                int index = dir.ordinal();
                if ((key & 1 << index) == 0) continue;
                cached = Shapes.joinUnoptimized((VoxelShape)cached, (VoxelShape)SIDE_SHAPES[index], (BooleanOp)BooleanOp.OR);
            }
            cached = cached.optimize();
            Map<Byte, VoxelShape> map = SHAPE_CACHE;
            synchronized (map) {
                SHAPE_CACHE.put(key, cached);
            }
        }
        return cached;
    }

    public AbstractLowEntityKineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void clearInformationWalkCache() {
        informationWalkResult = null;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        AbstractLowEntityKineticBlock lek;
        boolean call_super = true;
        Block block = pNewState.getBlock();
        if (block instanceof AbstractLowEntityKineticBlock && (lek = (AbstractLowEntityKineticBlock)block).getBlockEntityType() == this.getBlockEntityType()) {
            call_super = false;
        }
        if (call_super) {
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
        if (pLevel.isClientSide) {
            AbstractLowEntityKineticBlock.clearInformationWalkCache();
        }
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        AbstractLowEntityKineticBlock b;
        if (!level.isClientSide) {
            return pos;
        }
        Block block = state.getBlock();
        if (block instanceof AbstractLowEntityKineticBlock && (b = (AbstractLowEntityKineticBlock)block).isActive(state)) {
            return pos;
        }
        if (informationWalkResult == null || !informationWalkResult.visited().contains(pos)) {
            informationWalkResult = AbstractLowEntityKineticBlockEntity.walkBlocks(level, pos, 1);
        }
        if (!informationWalkResult.entities().isEmpty()) {
            return informationWalkResult.entities().firstKey();
        }
        return pos;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EncasableBlock encasable;
        ItemInteractionResult result;
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AbstractLowEntityKineticBlock abstractLowEntityKineticBlock = this;
        if (abstractLowEntityKineticBlock instanceof EncasableBlock && (result = (encasable = (EncasableBlock)abstractLowEntityKineticBlock).tryEncase(state, level, pos, stack, player, hand, hitResult)).consumesAction()) {
            return result;
        }
        IPlacementHelper helper = this.getPlacementHelper();
        if (helper != null && helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean shouldConnectImpl(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        Block otherBlock = otherState.getBlock();
        if (otherBlock instanceof AbstractLowEntityKineticBlock) {
            AbstractLowEntityKineticBlock lek = (AbstractLowEntityKineticBlock)otherBlock;
            DyeColor color = this.getColor(state);
            DyeColor otherColor = lek.getColor(otherState);
            return color == null || otherColor == null || color == otherColor;
        }
        return false;
    }

    public final boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction) {
        BlockPos otherPos = pos.relative(direction);
        BlockState otherState = level.getBlockState(otherPos);
        return this.connectsTo(level, pos, state, direction, otherPos, otherState);
    }

    public final boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        Block block = otherState.getBlock();
        if (!(block instanceof AbstractLowEntityKineticBlock)) {
            return false;
        }
        AbstractLowEntityKineticBlock lek = (AbstractLowEntityKineticBlock)block;
        return this.shouldConnectImpl(level, pos, state, direction, otherPos, otherState) && lek.shouldConnectImpl(level, otherPos, otherState, direction.getOpposite(), pos, state);
    }

    public abstract boolean isActive(BlockState var1);

    @Nullable
    abstract DyeColor getColor(BlockState var1);

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> type) {
        if (this.isActive(state)) {
            return new SmartBlockEntityTicker();
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this.isActive(state)) {
            return this.getBlockEntityType().create(pos, state);
        }
        return null;
    }
}

