/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.content.logistics.BigItemStack;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.data.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaBigItemStack;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaComparable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class LuaSaleObject
implements LuaComparable {
    private final SalesHistoryData Data;
    private final SalesHistoryData.Sale Sale;

    public LuaSaleObject(SalesHistoryData parent, SalesHistoryData.Sale sale) {
        this.Data = parent;
        this.Sale = sale;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getPlayer() {
        UUID player = this.Data.getPlayers().get(this.Sale.player());
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        if (server == null || server.getProfileCache() == null || player == null) {
            return null;
        }
        Optional cached = server.getProfileCache().get(player);
        if (cached.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", ((GameProfile)cached.get()).getId().toString());
        result.put("name", ((GameProfile)cached.get()).getName());
        return result;
    }

    private Map<Integer, ?> hydrateItems(Collection<Map.Entry<String, Integer>> entries) {
        HashMap result = new HashMap();
        int i = 0;
        for (Map.Entry<String, Integer> entry : entries) {
            Item item = this.Data.getItem(entry.getKey());
            LuaBigItemStack stack = item == null ? null : new LuaBigItemStack(new BigItemStack(item.getDefaultInstance(), entry.getValue().intValue()));
            result.put(++i, stack == null ? null : stack.getSimple());
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final long getTimestamp() {
        return this.Sale.timestamp();
    }

    @LuaFunction(mainThread=true)
    public final int paymentCount() {
        Map<String, Integer> payment = this.Sale.payment();
        return payment == null ? 0 : payment.size();
    }

    @LuaFunction(mainThread=true)
    public final int purchasedCount() {
        Map<String, Integer> purchased = this.Sale.purchase();
        return purchased == null ? 0 : purchased.size();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<Integer, ?> payment() {
        Map<String, Integer> source = this.Sale.payment();
        if (source == null || source.isEmpty()) {
            return null;
        }
        return this.hydrateItems(source.entrySet());
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getPaymentDetail(int slot) throws LuaException {
        Map<String, Integer> source = this.Sale.payment();
        if (source == null) {
            return null;
        }
        int idx = slot - 1;
        if (idx < 0 || idx >= source.size()) {
            throw new LuaException("Slot " + slot + " out of range, available slots between 1 and " + (source.size() + 1));
        }
        int i = 0;
        for (String entry : source.keySet()) {
            if (i == idx) {
                Item item = this.Data.getItem(entry);
                if (item == null) {
                    return null;
                }
                return new LuaBigItemStack(new BigItemStack(item.getDefaultInstance(), source.get(entry).intValue())).getDetailed();
            }
            ++i;
        }
        throw new LuaException("Runtime error");
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<Integer, ?> purchased() {
        Map<String, Integer> purchased = this.Sale.purchase();
        if (purchased == null || purchased.isEmpty()) {
            return null;
        }
        return this.hydrateItems(purchased.entrySet());
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getPurchasedDetail(int slot) throws LuaException {
        Map<String, Integer> source = this.Sale.purchase();
        if (source == null) {
            return null;
        }
        int idx = slot - 1;
        if (idx < 0 || idx >= source.size()) {
            throw new LuaException("Slot " + slot + " out of range, available slots between 1 and " + (source.size() + 1));
        }
        int i = 0;
        for (String entry : source.keySet()) {
            if (i == idx) {
                Item item = this.Data.getItem(entry);
                if (item == null) {
                    return null;
                }
                return new LuaBigItemStack(new BigItemStack(item.getDefaultInstance(), source.get(entry).intValue())).getDetailed();
            }
            ++i;
        }
        throw new LuaException("Runtime error");
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("player", this.getPlayer());
        map.put("timestamp", this.getTimestamp());
        map.put("payment", this.payment());
        map.put("purchasedItems", this.purchased());
        return map;
    }
}

