/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.khloeleclair.create.additionallogistics.client.CreateAdditionalLogisticsClient;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.datagen.DataGen;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlocks;
import dev.khloeleclair.create.additionallogistics.common.registries.CALEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.common.registries.CALMenuTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPartialModels;
import dev.khloeleclair.create.additionallogistics.common.registries.CALStress;
import dev.khloeleclair.create.additionallogistics.common.registries.CALTags;
import dev.khloeleclair.create.additionallogistics.common.utilities.CurrencyUtilities;
import dev.khloeleclair.create.additionallogistics.common.utilities.RecipeHelper;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="createadditionallogistics")
public class CreateAdditionalLogistics {
    public static final String MODID = "createadditionallogistics";
    public static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static MinecraftServer server;
    public static final NonNullSupplier<CreateRegistrate> REGISTRATE;

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Nullable
    public static MinecraftServer getServer() {
        return server;
    }

    public CreateAdditionalLogistics() {
        this(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public CreateAdditionalLogistics(IEventBus modEventBus) {
        ((CreateRegistrate)REGISTRATE.get()).registerEventListeners(modEventBus);
        CurrencyUtilities.init();
        CALTags.init();
        CALBlocks.register();
        CALItems.register();
        CALMenuTypes.register();
        CALEntityTypes.register();
        CALBlockEntityTypes.register();
        CALStress.register();
        CALPartialModels.register();
        CALComputerCraftProxy.register();
        CALPackets.register();
        modEventBus.addListener(EventPriority.HIGHEST, DataGen::gatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(RecipeHelper::onRecipesUpdated);
        MinecraftForge.EVENT_BUS.addListener(AbstractLowEntityKineticBlockEntity::onTick);
        Config.register();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CreateAdditionalLogisticsClient::new);
    }

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        server = event.getServer();
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        server = null;
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Entity passenger;
        BlockPos ticker;
        List passengers;
        List seats;
        if (!((Boolean)Config.Common.protectStockKeeperSeats.get()).booleanValue()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (level.m_8055_(pos).m_60734_() instanceof SeatBlock && !(seats = level.m_45976_(SeatEntity.class, new AABB(pos))).isEmpty() && !(passengers = ((SeatEntity)seats.get(0)).m_20197_()).isEmpty() && (ticker = StockTickerInteractionHandler.getStockTickerPosition((Entity)(passenger = (Entity)passengers.get(0)))) != null) {
            event.setCanceled(true);
        }
    }

    static {
        REGISTRATE = NonNullSupplier.lazy(() -> CreateRegistrate.create((String)MODID).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item)))));
    }
}

