/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.content.logistics.cashRegister;

import com.simibubi.create.content.logistics.BigItemStack;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SalesLedgerScreen
extends AbstractSimiScreen {
    public final SalesHistoryData Data;
    public final Map<UUID, String> PlayerNames;
    @Nullable
    private Button btnPrevious;
    @Nullable
    private Button btnNext;
    private String query;
    private int page;
    private int pages;
    private int perPage;
    private final List<SalesHistoryData.Sale> filteredSales;

    public SalesLedgerScreen(ItemStack stack, Map<UUID, String> playerNames) {
        super(stack.m_41786_());
        this.Data = SalesHistoryData.getOrEmpty(stack);
        this.PlayerNames = playerNames;
        this.query = "";
        this.page = -1;
        this.perPage = 10;
        this.filteredSales = new ArrayList<SalesHistoryData.Sale>();
    }

    private void updateFiltered() {
        this.filteredSales.clear();
        if (!this.query.isBlank()) {
            Map<String, UUID> uuids = this.Data.getPlayers();
            for (SalesHistoryData.Sale sale : this.Data.getSales()) {
                boolean matches = false;
                String name = this.PlayerNames.get(uuids.get(sale.player()));
                if (name != null && name.contains(this.query)) {
                    matches = true;
                }
                if (!matches) continue;
                this.filteredSales.add(sale);
            }
        } else {
            this.filteredSales.addAll(this.Data.getSales());
        }
        this.pages = Math.max(1, Mth.m_184652_((int)this.filteredSales.size(), (int)this.perPage));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.page = 0;
        this.resizeElements();
        this.layoutPage();
    }

    private void resizeElements() {
        this.perPage = 10;
        if (this.f_96544_ < 360) {
            this.perPage = Mth.m_14045_((int)((this.f_96544_ - 86) / 22), (int)2, (int)10);
        }
        this.pages = Math.max(1, Mth.m_184652_((int)this.filteredSales.size(), (int)this.perPage));
    }

    private void changePage(int p) {
        if (p < 0) {
            p = this.pages - 1;
        }
        if (p >= this.pages) {
            p = 0;
        }
        if (this.page == p) {
            return;
        }
        this.page = p;
        this.layoutPage();
    }

    private void hydrateItems(Map<String, BigItemStack> cache, Collection<Map.Entry<String, Integer>> entries) {
        for (Map.Entry<String, Integer> entry : entries) {
            BigItemStack stack = cache.get(entry.getKey());
            if (stack == null) {
                Item item = this.Data.getItem(entry.getKey());
                if (item == null) continue;
                stack = new BigItemStack(item.m_7968_(), 0);
                cache.put(entry.getKey(), stack);
            }
            stack.count += entry.getValue().intValue();
        }
    }

    private void layoutPage() {
        this.m_169413_();
        GridLayout layout = new GridLayout();
        layout.m_264211_().m_264129_(2, 2, 2, 0).m_264623_();
        GridLayout.RowHelper helper = layout.m_264606_(4);
        helper.m_264108_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_).m_267729_(), 3);
        helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.text("(WIP)").style(ChatFormatting.GRAY).component(), this.f_96547_), 1);
        helper.m_264108_((LayoutElement)new SpacerElement(50, 10), 4);
        Object2ObjectArrayMap payments = new Object2ObjectArrayMap();
        Object2ObjectArrayMap sold = new Object2ObjectArrayMap();
        for (SalesHistoryData.Sale sale : this.Data.getSales()) {
            this.hydrateItems((Map<String, BigItemStack>)payments, sale.payment().entrySet());
            this.hydrateItems((Map<String, BigItemStack>)sold, sale.purchase().entrySet());
        }
        helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.translate("sales.sales", CALLang.number(this.Data.saleCount()).style(ChatFormatting.GOLD)).component(), this.f_96547_), 4);
        helper.m_264108_((LayoutElement)new SpacerElement(50, 10), 4);
        helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.text("Income:").component(), this.f_96547_), 4);
        for (BigItemStack stack : payments.values()) {
            helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.number(stack.count).text("x ").style(ChatFormatting.GRAY).add(stack.stack.m_41786_()).component(), this.f_96547_), 4);
        }
        helper.m_264108_((LayoutElement)new SpacerElement(50, 10), 4);
        helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.text("Sold Items:").component(), this.f_96547_), 4);
        for (BigItemStack stack : sold.values()) {
            helper.m_264108_((LayoutElement)new StringWidget((Component)CALLang.number(stack.count).text("x ").style(ChatFormatting.GRAY).add(stack.stack.m_41786_()).component(), this.f_96547_), 4);
        }
        layout.m_264036_();
        FrameLayout.m_264460_((LayoutElement)layout, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.5f, (float)0.5f);
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }
}

