/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.widgets;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.client.content.kinetics.lazy.LowEntityKineticBlockEntityRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BlockPreviewWidget
extends AbstractWidget {
    private static final Quaternionf ROT_180_Z = Axis.f_252403_.m_252961_((float)Math.PI);
    private static final Vec3 RAY_ORIGIN = new Vec3(1.5, 1.5, 1.5);
    private static final Vec3 RAY_START = new Vec3(1.5, 1.5, -1.0);
    private static final Vec3 RAY_END = new Vec3(1.5, 1.5, 3.0);
    private static final BlockPos POS = new BlockPos(1, 1, 1);
    private static final int Z_OFFSET = 100;
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final ResourceLocation SELECTED_ICON = CreateAdditionalLogistics.asResource("block/highlighted");
    private static MultiBufferSource.BufferSource ghostBuffers;
    private static MultiBufferSource.BufferSource solidBuffers;
    private final Vector3f worldOrigin;
    @Nullable
    private Predicate<Direction> canSelectDirection;
    @Nullable
    private BiConsumer<Direction, Integer> clickedDirection;
    private final BlockPos position;
    private final List<BlockPos> neighbors = new ArrayList<BlockPos>();
    private float scale = 80.0f;
    private float pitch;
    private float yaw;
    private boolean didClick = false;
    private boolean neighborsVisible = true;
    @Nullable
    private SelectedFace selection;

    public BlockPreviewWidget(int x, int y, int width, int height, BlockPos position) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.position = position;
        this.worldOrigin = new Vector3f((float)position.m_123341_() + 0.5f, (float)position.m_123342_() + 0.5f, (float)position.m_123343_() + 0.5f);
        for (Direction dir : Iterate.directions) {
            this.neighbors.add(position.m_121945_(dir));
        }
        this.pitch = BlockPreviewWidget.MINECRAFT.f_91074_.m_146909_();
        this.yaw = BlockPreviewWidget.MINECRAFT.f_91074_.m_146908_();
        this.initBuffers(MINECRAFT.m_91269_().m_110104_());
    }

    public BlockPreviewWidget canSelectDirection(@Nullable Predicate<Direction> predicate) {
        this.canSelectDirection = predicate;
        return this;
    }

    public BlockPreviewWidget onClick(@Nullable BiConsumer<Direction, Integer> consumer) {
        this.clickedDirection = consumer;
        return this;
    }

    private void initBuffers(MultiBufferSource.BufferSource original) {
        BufferBuilder fallback = original.f_109904_;
        Map layerBuffers = original.f_109905_;
        Object2ObjectLinkedOpenHashMap ghostLayers = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap solidLayers = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            ghostLayers.put(GhostRenderLayer.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
            solidLayers.put(SolidRenderLayer.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
        }
        ghostBuffers = new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)ghostLayers);
        solidBuffers = new SolidBuffers(fallback, (Map<RenderType, BufferBuilder>)solidLayers);
    }

    private static Vec3 transform(Vec3 vec, Matrix4f transform) {
        Vector4f vec4 = new Vector4f((float)(vec.f_82479_ - BlockPreviewWidget.RAY_ORIGIN.f_82479_), (float)(vec.f_82480_ - BlockPreviewWidget.RAY_ORIGIN.f_82480_), (float)(vec.f_82481_ - BlockPreviewWidget.RAY_ORIGIN.f_82481_), 1.0f);
        vec4.mul((Matrix4fc)transform);
        return new Vec3((double)vec4.x() + BlockPreviewWidget.RAY_ORIGIN.f_82479_, (double)vec4.y() + BlockPreviewWidget.RAY_ORIGIN.f_82480_, (double)vec4.z() + BlockPreviewWidget.RAY_ORIGIN.f_82481_);
    }

    @Nullable
    private BlockHitResult raycast(BlockPos pos, BlockState state, float diffX, float diffY, Matrix4f transform) {
        Vec3 start = RAY_START.m_82520_((double)diffX, (double)diffY, 0.0);
        Vec3 end = RAY_END.m_82520_((double)diffX, (double)diffY, 0.0);
        start = BlockPreviewWidget.transform(start, transform);
        end = BlockPreviewWidget.transform(end, transform);
        VoxelShape shape = Shapes.m_83144_();
        Vector3f centerPos = new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f).sub((Vector3fc)this.worldOrigin);
        shape = shape.m_83216_((double)centerPos.x(), (double)centerPos.y(), (double)centerPos.z());
        return shape.m_83220_(start, end, POS);
    }

    public void toggleNeighborVisibility() {
        this.neighborsVisible = !this.neighborsVisible;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.didClick = false;
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_ && this.didClick && this.selection != null && this.clickedDirection != null) {
            this.clickedDirection.accept(this.selection.side, button);
        }
        this.didClick = false;
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.didClick = true;
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.didClick = false;
        if (this.f_93624_ && this.m_7972_(button) && this.m_5953_(mouseX, mouseY)) {
            double dx = dragX / (double)MINECRAFT.m_91268_().m_85445_();
            double dy = dragY / (double)MINECRAFT.m_91268_().m_85446_();
            this.yaw += 4.0f * (float)dx * 180.0f;
            this.pitch += 2.0f * (float)dy * 180.0f;
            this.pitch = Math.min(80.0f, Math.max(-80.0f, this.pitch));
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_) {
            this.scale -= (float)delta;
            this.scale = Math.min(160.0f, Math.max(10.0f, this.scale));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        LowEntityKineticBlockEntityRenderer.overrideVisualization = true;
        try {
            guiGraphics.m_280588_(x, y, x + this.f_93618_, y + this.f_93619_);
            int centerX = this.m_252754_() + this.f_93618_ / 2;
            int centerY = this.m_252907_() + this.f_93619_ / 2;
            float diffX = (float)(mouseX - centerX) / this.scale;
            float diffY = (float)(mouseY - centerY) / this.scale;
            Quaternionf rotPitch = Axis.f_252495_.m_252977_(this.pitch);
            Quaternionf rotYaw = Axis.f_252436_.m_252977_(this.yaw);
            Quaternionf blockTransform = new Quaternionf((Quaternionfc)ROT_180_Z);
            blockTransform.mul((Quaternionfc)rotPitch);
            blockTransform.mul((Quaternionfc)rotYaw);
            this.renderWorld(guiGraphics, centerX, centerY, blockTransform, partialTick);
            Matrix4f rayTransform = new Matrix4f();
            rayTransform.set((Quaternionfc)ROT_180_Z);
            rayTransform.rotate((Quaternionfc)rotYaw);
            rayTransform.rotate((Quaternionfc)rotPitch);
            HashMap<BlockHitResult, BlockPos> hits = new HashMap<BlockHitResult, BlockPos>();
            BlockState state = BlockPreviewWidget.MINECRAFT.f_91073_.m_8055_(this.position);
            BlockHitResult hit = this.raycast(this.position, state, diffX, diffY, rayTransform);
            if (hit != null && hit.m_6662_() != HitResult.Type.MISS && (this.canSelectDirection == null || this.canSelectDirection.test(hit.m_82434_()))) {
                hits.put(hit, this.position);
            }
            Vec3 eyePosition = BlockPreviewWidget.transform(RAY_START, rayTransform).m_82520_((double)this.worldOrigin.x, (double)this.worldOrigin.y, (double)this.worldOrigin.z);
            this.selection = hits.entrySet().stream().min(Comparator.comparingDouble(entry -> ((BlockPos)entry.getValue()).m_203193_((Position)eyePosition))).map(closest -> new SelectedFace((BlockPos)closest.getValue(), ((BlockHitResult)closest.getKey()).m_82434_())).orElse(null);
            this.renderSelection(guiGraphics, centerX, centerY, blockTransform);
            guiGraphics.m_280618_();
        }
        finally {
            LowEntityKineticBlockEntityRenderer.overrideVisualization = false;
        }
    }

    private void renderWorld(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform, float partialTick) {
        Lighting.m_84930_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY, 100.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, -this.scale);
        guiGraphics.m_280168_().m_252781_(transform);
        if (this.neighborsVisible) {
            for (BlockPos neighbour : this.neighbors) {
                Vector3f pos = new Vector3f((float)neighbour.m_123341_() - this.worldOrigin.x(), (float)neighbour.m_123342_() - this.worldOrigin.y(), (float)neighbour.m_123343_() - this.worldOrigin.z());
                this.renderBlock(guiGraphics, neighbour, pos, ghostBuffers, partialTick);
            }
        }
        ghostBuffers.m_109911_();
        Vector3f pos = new Vector3f((float)this.position.m_123341_() - this.worldOrigin.x(), (float)this.position.m_123342_() - this.worldOrigin.y(), (float)this.position.m_123343_() - this.worldOrigin.z());
        this.renderBlock(guiGraphics, this.position, pos, solidBuffers, partialTick);
        solidBuffers.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    private void renderBlock(GuiGraphics guiGraphics, BlockPos blockPos, Vector3f renderPos, MultiBufferSource.BufferSource buffers, float partialTick) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(renderPos.x(), renderPos.y(), renderPos.z());
        ModelData modelData = Optional.ofNullable(BlockPreviewWidget.MINECRAFT.f_91073_.getModelDataManager().getAt(blockPos)).orElse(ModelData.EMPTY);
        BlockState blockState = BlockPreviewWidget.MINECRAFT.f_91073_.m_8055_(blockPos);
        RenderShape rendershape = blockState.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            BlockEntityRenderer beRenderer;
            BlockEntity blockEntity;
            if (rendershape == RenderShape.MODEL) {
                BlockRenderDispatcher renderer = MINECRAFT.m_91289_();
                BakedModel bakedmodel = renderer.m_110910_(blockState);
                modelData = bakedmodel.getModelData((BlockAndTintGetter)BlockPreviewWidget.MINECRAFT.f_91073_, blockPos, blockState, modelData);
                int blockColor = MINECRAFT.m_91298_().m_92577_(blockState, (BlockAndTintGetter)BlockPreviewWidget.MINECRAFT.f_91073_, blockPos, 0);
                float r = (float)FastColor.ARGB32.m_13665_((int)blockColor) / 255.0f;
                float g = (float)FastColor.ARGB32.m_13667_((int)blockColor) / 255.0f;
                float b = (float)FastColor.ARGB32.m_13669_((int)blockColor) / 255.0f;
                for (RenderType renderType : bakedmodel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                    renderer.m_110937_().renderModel(guiGraphics.m_280168_().m_85850_(), buffers.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), blockState, bakedmodel, r, g, b, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
                }
            }
            if ((blockEntity = BlockPreviewWidget.MINECRAFT.f_91073_.m_7702_(blockPos)) != null && (beRenderer = MINECRAFT.m_167982_().m_112265_(blockEntity)) != null) {
                beRenderer.m_6922_(blockEntity, partialTick, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderSelection(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform) {
        if (this.selection == null) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY, 100.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, -this.scale);
        guiGraphics.m_280168_().m_252781_(transform);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        RenderSystem.setShader(GameRenderer::m_172820_);
        TextureAtlasSprite tex = (TextureAtlasSprite)MINECRAFT.m_91258_(InventoryMenu.f_39692_).apply(SELECTED_ICON);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex.m_247685_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlockPos blockPos = this.selection.blockPos;
        guiGraphics.m_280168_().m_252880_((float)blockPos.m_123341_() - this.worldOrigin.x(), (float)blockPos.m_123342_() - this.worldOrigin.y(), (float)blockPos.m_123343_() - this.worldOrigin.z());
        Vector3f[] vec = BlockPreviewWidget.createQuadVerts(this.selection.side, 0.0f, 1.0f, 1.0f);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_252986_(matrix4f, vec[0].x(), vec[0].y(), vec[0].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118409_(), tex.m_118411_());
        bufferbuilder.m_252986_(matrix4f, vec[1].x(), vec[1].y(), vec[1].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118409_(), tex.m_118412_());
        bufferbuilder.m_252986_(matrix4f, vec[2].x(), vec[2].y(), vec[2].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118410_(), tex.m_118412_());
        bufferbuilder.m_252986_(matrix4f, vec[3].x(), vec[3].y(), vec[3].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118410_(), tex.m_118411_());
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        guiGraphics.m_280168_().m_85849_();
    }

    public static Vector3f[] createQuadVerts(Direction face, float leftEdge, float rightEdge, float elevation) {
        Vector3f[] vector3fArray;
        switch (face) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                Vector3f[] vector3fArray2 = new Vector3f[4];
                vector3fArray2[0] = new Vector3f(leftEdge, 1.0f - elevation, leftEdge);
                vector3fArray2[1] = new Vector3f(rightEdge, 1.0f - elevation, leftEdge);
                vector3fArray2[2] = new Vector3f(rightEdge, 1.0f - elevation, rightEdge);
                vector3fArray = vector3fArray2;
                vector3fArray2[3] = new Vector3f(leftEdge, 1.0f - elevation, rightEdge);
                break;
            }
            case UP: {
                Vector3f[] vector3fArray3 = new Vector3f[4];
                vector3fArray3[0] = new Vector3f(leftEdge, elevation, leftEdge);
                vector3fArray3[1] = new Vector3f(leftEdge, elevation, rightEdge);
                vector3fArray3[2] = new Vector3f(rightEdge, elevation, rightEdge);
                vector3fArray = vector3fArray3;
                vector3fArray3[3] = new Vector3f(rightEdge, elevation, leftEdge);
                break;
            }
            case NORTH: {
                Vector3f[] vector3fArray4 = new Vector3f[4];
                vector3fArray4[0] = new Vector3f(rightEdge, rightEdge, 1.0f - elevation);
                vector3fArray4[1] = new Vector3f(rightEdge, leftEdge, 1.0f - elevation);
                vector3fArray4[2] = new Vector3f(leftEdge, leftEdge, 1.0f - elevation);
                vector3fArray = vector3fArray4;
                vector3fArray4[3] = new Vector3f(leftEdge, rightEdge, 1.0f - elevation);
                break;
            }
            case SOUTH: {
                Vector3f[] vector3fArray5 = new Vector3f[4];
                vector3fArray5[0] = new Vector3f(leftEdge, rightEdge, elevation);
                vector3fArray5[1] = new Vector3f(leftEdge, leftEdge, elevation);
                vector3fArray5[2] = new Vector3f(rightEdge, leftEdge, elevation);
                vector3fArray = vector3fArray5;
                vector3fArray5[3] = new Vector3f(rightEdge, rightEdge, elevation);
                break;
            }
            case WEST: {
                Vector3f[] vector3fArray6 = new Vector3f[4];
                vector3fArray6[0] = new Vector3f(1.0f - elevation, rightEdge, leftEdge);
                vector3fArray6[1] = new Vector3f(1.0f - elevation, leftEdge, leftEdge);
                vector3fArray6[2] = new Vector3f(1.0f - elevation, leftEdge, rightEdge);
                vector3fArray = vector3fArray6;
                vector3fArray6[3] = new Vector3f(1.0f - elevation, rightEdge, rightEdge);
                break;
            }
            case EAST: {
                Vector3f[] vector3fArray7 = new Vector3f[4];
                vector3fArray7[0] = new Vector3f(elevation, rightEdge, rightEdge);
                vector3fArray7[1] = new Vector3f(elevation, leftEdge, rightEdge);
                vector3fArray7[2] = new Vector3f(elevation, leftEdge, leftEdge);
                vector3fArray = vector3fArray7;
                vector3fArray7[3] = new Vector3f(elevation, rightEdge, leftEdge);
            }
        }
        return vector3fArray;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> REMAPPED_TYPES = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original, "createadditionallogistics"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.m_110188_();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return REMAPPED_TYPES.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class SolidRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> REMAPPED_TYPES = new IdentityHashMap<RenderType, RenderType>();

        private SolidRenderLayer(RenderType original) {
            super(String.format("%s_%s_solid", original, "createadditionallogistics"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> original.m_110185_(), () -> original.m_110188_());
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof SolidRenderLayer) {
                return in;
            }
            return REMAPPED_TYPES.computeIfAbsent(in, SolidRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        private GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer m_6299_(RenderType type) {
            return super.m_6299_(GhostRenderLayer.remap(type));
        }
    }

    private static class SolidBuffers
    extends MultiBufferSource.BufferSource {
        private SolidBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer m_6299_(RenderType type) {
            return super.m_6299_(SolidRenderLayer.remap(type));
        }
    }

    private record SelectedFace(BlockPos blockPos, Direction side) {
    }
}

