/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base;

import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.AbstractFlexibleShaftBlock;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazySimpleKineticBlock<T extends AbstractLowEntityKineticBlockEntity>
extends AbstractLowEntityKineticBlock<T>
implements EncasableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty NEGATIVE = BooleanProperty.m_61465_((String)"negative");
    public static final BooleanProperty POSITIVE = BooleanProperty.m_61465_((String)"positive");

    public AbstractLazySimpleKineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = this.m_49966_();
        if (state.m_61138_((Property)ProperWaterloggedBlock.WATERLOGGED)) {
            state = (BlockState)state.m_61124_((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)NEGATIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POSITIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState copyValuesForCasing(BlockState from, BlockState to) {
        if (from.m_61138_((Property)ProperWaterloggedBlock.WATERLOGGED) && to.m_61138_((Property)ProperWaterloggedBlock.WATERLOGGED)) {
            to = (BlockState)to.m_61124_((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)((Boolean)from.m_61143_((Property)ProperWaterloggedBlock.WATERLOGGED)));
        }
        if (from.m_61138_(AXIS) && to.m_61138_(AXIS)) {
            to = (BlockState)to.m_61124_(AXIS, (Comparable)((Direction.Axis)from.m_61143_(AXIS)));
        }
        if (from.m_61138_((Property)POSITIVE) && to.m_61138_((Property)POSITIVE)) {
            to = (BlockState)to.m_61124_((Property)POSITIVE, (Comparable)((Boolean)from.m_61143_((Property)POSITIVE)));
        }
        if (from.m_61138_((Property)NEGATIVE) && to.m_61138_((Property)NEGATIVE)) {
            to = (BlockState)to.m_61124_((Property)NEGATIVE, (Comparable)((Boolean)from.m_61143_((Property)NEGATIVE)));
        }
        return to;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (!(oldState.m_60734_() instanceof AbstractLazySimpleKineticBlock) || !(newState.m_60734_() instanceof AbstractLazySimpleKineticBlock)) {
            return false;
        }
        if (ICogWheel.isLargeCog((BlockState)oldState) != ICogWheel.isLargeCog((BlockState)newState)) {
            return false;
        }
        if (ICogWheel.isSmallCog((BlockState)oldState) != ICogWheel.isSmallCog((BlockState)newState)) {
            return false;
        }
        if (!oldState.m_61138_(AXIS) || !newState.m_61138_(AXIS)) {
            return false;
        }
        return oldState.m_61143_(AXIS) == newState.m_61143_(AXIS);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        byte key = 0;
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        boolean positive = (Boolean)state.m_61143_((Property)POSITIVE);
        boolean negative = (Boolean)state.m_61143_((Property)NEGATIVE);
        if (positive) {
            key = (byte)(key | 1 << Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).ordinal());
        }
        if (negative) {
            key = (byte)(key | 1 << Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).ordinal());
        }
        return this.getShapeWithSides(key);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockState withSides(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        Direction positive = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction negative = positive.m_122424_();
        state = (BlockState)state.m_61124_((Property)POSITIVE, (Comparable)Boolean.valueOf(this.connectsTo(level, pos, state, positive)));
        state = (BlockState)state.m_61124_((Property)NEGATIVE, (Comparable)Boolean.valueOf(this.connectsTo(level, pos, state, negative)));
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS, POSITIVE, NEGATIVE});
        if (this instanceof ProperWaterloggedBlock) {
            builder.m_61104_(new Property[]{ProperWaterloggedBlock.WATERLOGGED});
        }
    }

    @Nullable
    public static Direction.Axis getPreferredAxis(BlockPlaceContext context) {
        Direction.Axis preferredAxis = null;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction side : Iterate.directions) {
            IRotate rot;
            Direction.Axis axis = side.m_122434_();
            BlockPos newPos = pos.m_121945_(side);
            BlockState newState = level.m_8055_(newPos);
            Block newBlock = newState.m_60734_();
            if (newBlock instanceof AbstractFlexibleShaftBlock) {
                if (context.m_43719_() == side.m_122424_()) {
                    return axis;
                }
                if (preferredAxis != null && preferredAxis != axis) {
                    preferredAxis = null;
                    break;
                }
                preferredAxis = axis;
            }
            if (!(newBlock instanceof IRotate) || !(rot = (IRotate)newBlock).hasShaftTowards((LevelReader)level, newPos, newState, side.m_122424_())) continue;
            if (context.m_43719_() == side.m_122424_()) {
                return axis;
            }
            if (preferredAxis != null && preferredAxis != axis) {
                preferredAxis = null;
                break;
            }
            preferredAxis = axis;
        }
        return preferredAxis;
    }

    @Nullable
    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        return AbstractLazySimpleKineticBlock.getPreferredAxis(context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState;
        AbstractLazySimpleKineticBlock abstractLazySimpleKineticBlock = this;
        if (abstractLazySimpleKineticBlock instanceof ProperWaterloggedBlock) {
            ProperWaterloggedBlock wlb = (ProperWaterloggedBlock)abstractLazySimpleKineticBlock;
            wlb.updateWater(level, state, pos);
        }
        if ((newState = this.withSides(level, pos, state)) != state && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return newState;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis preferred = this.getAxisForPlacement(context);
        BlockState state = preferred != null && (context.m_43723_() != null || !context.m_43723_().m_6144_()) ? (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)preferred) : (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)(preferred != null && context.m_43723_().m_6144_() ? context.m_43719_().m_122434_() : context.m_7820_().m_122434_()));
        state = this.withSides((LevelAccessor)context.m_43725_(), context.m_8083_(), state);
        AbstractLazySimpleKineticBlock abstractLazySimpleKineticBlock = this;
        if (abstractLazySimpleKineticBlock instanceof ProperWaterloggedBlock) {
            ProperWaterloggedBlock wlb = (ProperWaterloggedBlock)abstractLazySimpleKineticBlock;
            state = wlb.withWater(state, context);
        }
        return state;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.m_122434_() != state.m_61143_(AXIS)) {
            return false;
        }
        Direction.AxisDirection dir = face.m_122421_();
        if (dir == Direction.AxisDirection.POSITIVE) {
            return (Boolean)state.m_61143_((Property)POSITIVE) == false;
        }
        return (Boolean)state.m_61143_((Property)NEGATIVE) == false;
    }

    @Override
    protected boolean shouldConnectImpl(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, BlockPos otherPos, BlockState otherState) {
        if (direction.m_122434_() != state.m_61143_(AXIS)) {
            return false;
        }
        return super.shouldConnectImpl(level, pos, state, direction, otherPos, otherState);
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)NEGATIVE) == false || (Boolean)state.m_61143_((Property)POSITIVE) == false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_(AXIS);
    }
}

