/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLowEntityKineticBlockEntity
extends SplitShaftBlockEntity {
    @Nullable
    protected List<BlockPos> connections;
    @Nullable
    private List<BlockPos> pendingConnections;
    protected boolean checkInvalid;
    protected boolean lazyDirty;
    private static final Set<LevelBlockPos> dirtyPositions = new ObjectOpenHashSet();

    public AbstractLowEntityKineticBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.connections = null;
        if (compound.m_128425_("Connected", 12)) {
            long[] cache = compound.m_128467_("Connected");
            this.connections = new ArrayList<BlockPos>(cache.length);
            for (long pos : cache) {
                this.connections.add(BlockPos.m_122022_((long)pos));
            }
        } else if (compound.m_128425_("Connections", 12)) {
            this.lazyDirty = true;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.connections != null) {
            long[] cache = new long[this.connections.size()];
            int i = 0;
            for (BlockPos entry : this.connections) {
                cache[i] = entry.m_121878_();
                ++i;
            }
            compound.m_128388_("Connected", cache);
        }
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            if (this.lazyDirty || this.connections == null) {
                this.lazyDirty = false;
                AbstractLowEntityKineticBlockEntity.markDirty(this.f_58857_, this.f_58858_);
            }
            if (this.checkInvalid) {
                this.checkInvalid = false;
                this.removeInvalidConnections();
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.notifyConnectedToValidate();
    }

    public void removeInvalidConnections() {
        boolean changed = false;
        if (this.connections != null) {
            Iterator<BlockPos> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                BlockPos relative = this.f_58858_.m_121955_((Vec3i)pos);
                if (!this.f_58857_.m_46749_(relative) || this.f_58857_.m_7702_(relative) instanceof AbstractLowEntityKineticBlockEntity) continue;
                iterator.remove();
                changed = true;
            }
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    public void notifyConnectedToValidate() {
        if (this.connections != null && this.f_58857_ != null) {
            for (BlockPos pos : this.connections) {
                BlockEntity blockEntity;
                BlockPos relative = this.f_58858_.m_121955_((Vec3i)pos);
                if (!this.f_58857_.m_46749_(relative) || !((blockEntity = this.f_58857_.m_7702_(relative)) instanceof AbstractLowEntityKineticBlockEntity)) continue;
                AbstractLowEntityKineticBlockEntity lek = (AbstractLowEntityKineticBlockEntity)blockEntity;
                lek.checkInvalid = true;
            }
        }
    }

    public boolean isValidBlockState(BlockState state) {
        AbstractLowEntityKineticBlock lek;
        Block block = state.m_60734_();
        return block instanceof AbstractLowEntityKineticBlock && (lek = (AbstractLowEntityKineticBlock)block).isActive(state);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (this.connections != null) {
            this.connections.forEach(p -> {
                BlockPos pos = this.f_58858_.m_121955_((Vec3i)p);
                if (!neighbours.contains(pos)) {
                    neighbours.add(pos);
                }
            });
        }
        if (!ICogWheel.isLargeCog((BlockState)state)) {
            return super.addPropagationLocations(block, state, neighbours);
        }
        BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (offset.m_123331_((Vec3i)BlockPos.f_121853_) == 2.0) {
                neighbours.add(this.f_58858_.m_121955_((Vec3i)offset));
            }
        });
        return neighbours;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof AbstractLowEntityKineticBlockEntity && this.connections != null && this.connections.contains(target.m_58899_().m_121996_((Vec3i)this.f_58858_))) {
            return 1.0f;
        }
        return 0.0f;
    }

    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        BlockPos relative = other.m_58899_().m_121996_((Vec3i)this.f_58858_);
        return this.connections != null && this.connections.contains(relative);
    }

    protected boolean setConnections(List<BlockPos> newConnections) {
        boolean contains_next;
        int index;
        for (index = 0; index < newConnections.size() && !this.f_58858_.equals((Object)newConnections.get(index)); ++index) {
        }
        if (index >= newConnections.size()) {
            return false;
        }
        int previous = index - 1;
        int next = index + 1;
        if (this.connections == null) {
            this.connections = new ArrayList<BlockPos>();
        }
        @Nullable BlockPos prevPos = previous == -1 ? null : newConnections.get(previous).m_121996_((Vec3i)this.f_58858_);
        @Nullable BlockPos nextPos = next >= newConnections.size() ? null : newConnections.get(next).m_121996_((Vec3i)this.f_58858_);
        int count = (prevPos == null ? 0 : 1) + (nextPos == null ? 0 : 1);
        boolean contains_previous = prevPos == null || this.connections.contains(prevPos);
        boolean bl = contains_next = nextPos == null || this.connections.contains(nextPos);
        if (contains_previous && contains_next && this.connections.size() == count) {
            return false;
        }
        this.detachKinetics();
        this.pendingConnections = new ArrayList<BlockPos>();
        if (prevPos != null) {
            this.pendingConnections.add(prevPos);
        }
        if (nextPos != null) {
            this.pendingConnections.add(nextPos);
        }
        return true;
    }

    protected void finalizeConnections() {
        if (this.pendingConnections == null) {
            return;
        }
        this.connections = this.pendingConnections;
        this.pendingConnections = null;
        this.notifyUpdate();
        this.updateSpeed = true;
    }

    public static WalkResult walkBlocks(Level level, BlockPos pos) {
        return AbstractLowEntityKineticBlockEntity.walkBlocks(level, pos, Integer.MAX_VALUE);
    }

    public static WalkResult walkBlocks(Level level, BlockPos pos, int limit) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof AbstractLowEntityKineticBlock)) {
            return WalkResult.EMPTY;
        }
        AbstractLowEntityKineticBlock block2 = (AbstractLowEntityKineticBlock)block;
        ObjectOpenHashSet visited = new ObjectOpenHashSet();
        TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity> entities = new TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity>(Vec3i::compareTo);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        visited.add(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractLowEntityKineticBlockEntity) {
            AbstractLowEntityKineticBlockEntity lek = (AbstractLowEntityKineticBlockEntity)blockEntity;
            entities.put(pos, lek);
            if (entities.size() >= limit) {
                return new WalkResult((Set<BlockPos>)visited, entities);
            }
        }
        AbstractLowEntityKineticBlockEntity.addToDirtyList(level, pos, state, block2, (Set<BlockPos>)visited, queue);
        while (!queue.isEmpty()) {
            BlockState qstate;
            Block block3;
            BlockPos qpos = (BlockPos)queue.remove(0);
            if (!level.m_46749_(qpos) || !((block3 = (qstate = level.m_8055_(qpos)).m_60734_()) instanceof AbstractLowEntityKineticBlock)) continue;
            AbstractLowEntityKineticBlock qblock = (AbstractLowEntityKineticBlock)block3;
            BlockEntity blockEntity2 = level.m_7702_(qpos);
            if (blockEntity2 instanceof AbstractLowEntityKineticBlockEntity) {
                AbstractLowEntityKineticBlockEntity qlek = (AbstractLowEntityKineticBlockEntity)blockEntity2;
                entities.put(qpos, qlek);
                if (entities.size() >= limit) {
                    return new WalkResult((Set<BlockPos>)visited, entities);
                }
            }
            AbstractLowEntityKineticBlockEntity.addToDirtyList(level, qpos, qstate, qblock, (Set<BlockPos>)visited, queue);
        }
        return new WalkResult((Set<BlockPos>)visited, entities);
    }

    private static void addToDirtyList(Level world, BlockPos pos, BlockState state, AbstractLowEntityKineticBlock<?> block, Set<BlockPos> visited, List<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p = pos.m_121945_(direction);
            if (visited.contains(p) || !world.m_46749_(p) || !block.connectsTo((LevelAccessor)world, pos, state, direction, p, world.m_8055_(p))) continue;
            visited.add(p);
            queue.add(p);
        }
    }

    public static void markDirty(Level level, BlockPos pos) {
        if (level.f_46443_) {
            AbstractLowEntityKineticBlock.clearInformationWalkCache();
            return;
        }
        dirtyPositions.add(new LevelBlockPos(level, pos.m_7949_()));
    }

    public static void updateDirty() {
        LinkedList<LevelBlockPos> dirty = new LinkedList<LevelBlockPos>(dirtyPositions);
        dirtyPositions.clear();
        ArrayList<AbstractLowEntityKineticBlockEntity> toFinalize = new ArrayList<AbstractLowEntityKineticBlockEntity>();
        ObjectOpenHashSet levels = new ObjectOpenHashSet();
        while (!dirty.isEmpty()) {
            LevelBlockPos pos = dirty.removeFirst();
            WalkResult result = AbstractLowEntityKineticBlockEntity.walkBlocks(pos.level, pos.pos);
            Level level = pos.level;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                levels.add(sl);
            }
            if (!result.entities.isEmpty()) {
                List<BlockPos> entityPositions = result.entities.navigableKeySet().stream().toList();
                for (AbstractLowEntityKineticBlockEntity entity : result.entities.values()) {
                    if (!entity.setConnections(entityPositions)) continue;
                    toFinalize.add(entity);
                }
            }
            if (result.visited.isEmpty()) continue;
            dirty.removeIf(x -> result.visited.contains(x.pos));
        }
        for (AbstractLowEntityKineticBlockEntity entity : toFinalize) {
            entity.finalizeConnections();
        }
        for (ServerLevel level : levels) {
            CALPackets.ServerToClientEvent.CLEAR_INFORMATION.send(level);
        }
    }

    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !dirtyPositions.isEmpty()) {
            AbstractLowEntityKineticBlockEntity.updateDirty();
        }
    }

    public record WalkResult(Set<BlockPos> visited, TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity> entities) {
        public static WalkResult EMPTY = new WalkResult(Collections.emptySet(), new TreeMap<BlockPos, AbstractLowEntityKineticBlockEntity>());
    }

    private record LevelBlockPos(Level level, BlockPos pos) {
    }
}

