/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible;

import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.AbstractFlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlocks;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EncasedFlexibleShaftBlock
extends AbstractFlexibleShaftBlock
implements SpecialBlockItemRequirement,
EncasedBlock {
    public static final VoxelShape ENCASED_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape[] ENCASED_SIDE_SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final Map<Byte, VoxelShape> ENCASED_SHAPE_CACHE = new Byte2ObjectOpenHashMap();
    private final Supplier<Block> casing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VoxelShape getShapeWithSides(byte key) {
        VoxelShape cached;
        Map<Byte, VoxelShape> object = ENCASED_SHAPE_CACHE;
        synchronized (object) {
            cached = ENCASED_SHAPE_CACHE.get(key);
        }
        if (cached == null) {
            cached = ENCASED_SHAPE;
            for (Direction dir : Iterate.directions) {
                int index = dir.ordinal();
                if ((key & 1 << index) == 0) continue;
                cached = Shapes.m_83148_((VoxelShape)cached, (VoxelShape)ENCASED_SIDE_SHAPES[index], (BooleanOp)BooleanOp.f_82695_);
            }
            cached = cached.m_83296_();
            Map<Byte, VoxelShape> map = ENCASED_SHAPE_CACHE;
            synchronized (map) {
                ENCASED_SHAPE_CACHE.put(key, cached);
            }
        }
        return cached;
    }

    public EncasedFlexibleShaftBlock(BlockBehaviour.Properties properties, Supplier<Block> casing) {
        this(properties, null, casing);
    }

    public EncasedFlexibleShaftBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color, Supplier<Block> casing) {
        super(properties, color);
        this.casing = casing;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty prop = SIDES[direction.ordinal()];
        boolean connects = this.connectsTo(level, pos, state, direction, neighborPos, level.m_8055_(neighborPos));
        if (connects && !((Boolean)state.m_61143_((Property)prop)).booleanValue()) {
            BlockEntity blockEntity;
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FlexibleShaftBlockEntity) {
                FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
                fsb.setSide(direction, (byte)0);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return state;
    }

    protected BlockEntry<FlexibleShaftBlock> getUnencased() {
        if (this.color == null) {
            return CALBlocks.FLEXIBLE_SHAFT;
        }
        return CALBlocks.DYED_FLEXIBLE_SHAFTS.get(this.color);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)state));
        KineticBlockEntity.switchToBlockState((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (BlockState)this.getConnectedState(context.m_43725_(), context.m_8083_(), (BlockState)this.getUnencased().getDefaultState().m_61124_((Property)ACTIVE, (Comparable)((Boolean)state.m_61143_((Property)ACTIVE)))));
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (target instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)target;
            return (Boolean)state.m_61143_((Property)SIDES[result.m_82434_().ordinal()]) == false ? this.getUnencased().asStack() : this.getCasing().m_5456_().m_7968_();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public Block getCasing() {
        return this.casing.get();
    }

    public ItemRequirement getRequiredItems(BlockState state, @Nullable BlockEntity blockEntity) {
        return ItemRequirement.of((BlockState)this.getUnencased().getDefaultState(), (BlockEntity)blockEntity);
    }

    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        FlexibleShaftBlockEntity fsb;
        BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)((Boolean)state.m_61143_((Property)ACTIVE)));
        BlockEntity blockEntity = level.m_7702_(pos);
        FlexibleShaftBlockEntity be = blockEntity instanceof FlexibleShaftBlockEntity ? (fsb = (FlexibleShaftBlockEntity)blockEntity) : null;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.m_61124_((Property)SIDES[dir.ordinal()], (Comparable)Boolean.valueOf(be == null || be.getSide(dir) == 0));
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)newState);
    }
}

