/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.shaft;

import com.simibubi.create.foundation.placement.PoleHelper;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLazySimpleKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.AbstractFlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.shaft.LazyShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazyShaftBlock
extends AbstractLazySimpleKineticBlock<LazyShaftBlockEntity> {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final VoxelShape[] CONNECTOR_SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0)};

    public AbstractLazyShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        boolean positive = (Boolean)state.m_61143_((Property)POSITIVE);
        boolean negative = (Boolean)state.m_61143_((Property)NEGATIVE);
        if (positive && negative) {
            if (axis == Direction.Axis.X) {
                return CONNECTOR_SHAPES[0];
            }
            if (axis == Direction.Axis.Y) {
                return CONNECTOR_SHAPES[1];
            }
            return CONNECTOR_SHAPES[2];
        }
        return super.m_5940_(state, level, pos, context);
    }

    @Override
    @Nullable
    public DyeColor getColor(BlockState state) {
        return null;
    }

    public Class<LazyShaftBlockEntity> getBlockEntityClass() {
        return LazyShaftBlockEntity.class;
    }

    public BlockEntityType<? extends LazyShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.LAZY_SHAFT.get();
    }

    @Override
    @Nullable
    public IPlacementHelper getPlacementHelper() {
        return PlacementHelpers.get((int)placementHelperId);
    }

    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof AbstractLazyShaftBlock, state -> (Direction.Axis)state.m_61143_(AbstractLazySimpleKineticBlock.AXIS), AbstractLazySimpleKineticBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractLazyShaftBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> {
                if (s.m_60734_() instanceof AbstractLazyShaftBlock) {
                    return true;
                }
                return s.m_60734_() instanceof AbstractFlexibleShaftBlock;
            };
        }

        public PlacementOffset getOffsetFlexible(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.m_82450_());
            Direction side = (Direction)directions.get(0);
            BlockPos newPos = pos.m_121945_(side);
            BlockState newState = world.m_8055_(newPos);
            if (newState.m_247087_()) {
                return PlacementOffset.success((Vec3i)newPos, b -> (BlockState)b.m_61124_(AbstractLazySimpleKineticBlock.AXIS, (Comparable)side.m_122434_()));
            }
            return PlacementOffset.fail();
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset;
            PlacementOffset placementOffset = offset = state.m_60734_() instanceof AbstractFlexibleShaftBlock ? this.getOffsetFlexible(player, world, state, pos, ray) : super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> world.m_5776_() ? s : ((AbstractLazyShaftBlock)s.m_60734_()).withSides((LevelAccessor)world, offset.getBlockPos(), s)));
            }
            return offset;
        }
    }
}

