/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.registries;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.utility.AdventureUtil;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.client.content.kinetics.lazy.FlexibleShaftScreen;
import dev.khloeleclair.create.additionallogistics.client.content.logistics.cashRegister.SalesLedgerScreen;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLazySimpleKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.AbstractFlexibleShaftBlock;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.common.utilities.IPromiseLimit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.net.BasePacket;
import net.createmod.catnip.net.ClientboundPacket;
import net.createmod.catnip.net.ServerboundPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class CALPackets {
    private static int index = 0;
    public static final String PROTOCOL_VERSION = "3";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CreateAdditionalLogistics.asResource("main")).networkProtocolVersion(() -> "3").serverAcceptedVersions("3"::equals).clientAcceptedVersions("3"::equals).simpleChannel();

    protected static <T extends ClientboundPacket> void registerClientbound(Class<T> type, Function<FriendlyByteBuf, T> factory, Consumer<T> handler) {
        INSTANCE.messageBuilder(type, index++, NetworkDirection.PLAY_TO_CLIENT).encoder(BasePacket::write).decoder(factory).consumerNetworkThread(CALPackets.clientHandler(handler)).add();
    }

    private static <T extends ClientboundPacket> BiConsumer<T, Supplier<NetworkEvent.Context>> clientHandler(Consumer<T> handler) {
        return (t, contextSupplier) -> {
            CALPacket cp;
            if (t instanceof CALPacket && (cp = (CALPacket)t).runOnMainThread()) {
                Minecraft.m_91087_().execute(() -> handler.accept(t));
            } else {
                handler.accept(t);
            }
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        };
    }

    private static <T extends ServerboundPacket> void registerServerbound(Class<T> type, Function<FriendlyByteBuf, T> factory) {
        INSTANCE.messageBuilder(type, index++, NetworkDirection.PLAY_TO_SERVER).encoder(BasePacket::write).decoder(factory).consumerNetworkThread(CALPackets.serverHandler()).add();
    }

    private static <T extends ServerboundPacket> BiConsumer<T, Supplier<NetworkEvent.Context>> serverHandler() {
        return (t, contextSupplier) -> {
            CALPacket cp;
            MinecraftServer server;
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            MinecraftServer minecraftServer = server = sender == null ? null : sender.m_20194_();
            if (t instanceof CALPacket && (cp = (CALPacket)t).runOnMainThread()) {
                if (server != null) {
                    server.execute(() -> t.handle(server, sender));
                }
            } else {
                t.handle(sender != null ? sender.m_20194_() : null, sender);
            }
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        };
    }

    public static void register() {
        CALPackets.registerClientbound(ServerToClientEvent.class, ServerToClientEvent::new, ServerToClientEvent.Handler::handle);
        CALPackets.registerClientbound(OpenFlexibleShaftScreen.class, OpenFlexibleShaftScreen::new, OpenFlexibleShaftScreen.Handler::handle);
        CALPackets.registerClientbound(OpenSalesLedgerScreen.class, OpenSalesLedgerScreen::new, OpenSalesLedgerScreen.Handler::handle);
        CALPackets.registerServerbound(ConfigureFlexibleShaft.class, ConfigureFlexibleShaft::new);
        CALPackets.registerServerbound(UpdateGaugePromiseLimit.class, UpdateGaugePromiseLimit::new);
    }

    public static class ServerToClientEvent
    implements ClientboundPacket,
    CALPacket {
        public static final ResourceLocation ID = CreateAdditionalLogistics.asResource("server_to_client_event");
        private final String key;
        public static final ServerToClientEvent CLEAR_INFORMATION = new ServerToClientEvent("clear_information");

        public ServerToClientEvent(String key) {
            this.key = key;
        }

        public ServerToClientEvent(FriendlyByteBuf buffer) {
            this.key = buffer.m_130136_(Short.MAX_VALUE);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.key);
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void send(ServerLevel level) {
            INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)this);
        }

        public void send(ServerLevel level, BlockPos pos) {
            INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)160.0, (ResourceKey)level.m_46472_())), (Object)this);
        }

        public static class Handler {
            public static void handle(ServerToClientEvent packet) {
                if (packet.key.equals("clear_information")) {
                    AbstractLazySimpleKineticBlock.clearInformationWalkCache();
                }
            }
        }
    }

    public static class OpenFlexibleShaftScreen
    implements ClientboundPacket,
    CALPacket {
        public static final ResourceLocation ID = CreateAdditionalLogistics.asResource("open_flexible_shaft_screen");
        public final BlockPos pos;

        public static OpenFlexibleShaftScreen of(BlockPos pos) {
            return new OpenFlexibleShaftScreen(pos);
        }

        public OpenFlexibleShaftScreen(BlockPos pos) {
            this.pos = pos;
        }

        public OpenFlexibleShaftScreen(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void send(ServerPlayer player) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)this);
        }

        public static class Handler {
            public static void handle(OpenFlexibleShaftScreen packet) {
                if (Minecraft.m_91087_().f_91074_ == null) {
                    return;
                }
                Minecraft.m_91087_().m_91152_((Screen)new FlexibleShaftScreen(packet.pos));
            }
        }
    }

    public static class OpenSalesLedgerScreen
    implements ClientboundPacket,
    CALPacket {
        public static final ResourceLocation ID = CreateAdditionalLogistics.asResource("open_sales_ledger_screen");
        public final ItemStack stack;
        public final Map<UUID, String> playerNames;

        public OpenSalesLedgerScreen(ItemStack stack, Map<UUID, String> playerNames) {
            this.stack = stack;
            this.playerNames = playerNames;
        }

        public OpenSalesLedgerScreen(FriendlyByteBuf buffer) {
            this.stack = buffer.m_130267_();
            this.playerNames = buffer.m_236841_(HashMap::new, FriendlyByteBuf::m_130259_, FriendlyByteBuf::m_130277_);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130055_(this.stack);
            buffer.m_236831_(this.playerNames, FriendlyByteBuf::m_130077_, FriendlyByteBuf::m_130070_);
        }

        public ResourceLocation getId() {
            return ID;
        }

        public static Optional<OpenSalesLedgerScreen> create(ItemStack stack) {
            GameProfileCache cache;
            if (stack.m_41619_() || !stack.m_150930_((Item)CALItems.SALES_LEDGER.get())) {
                return Optional.empty();
            }
            SalesHistoryData history = SalesHistoryData.get(stack);
            MinecraftServer server = CreateAdditionalLogistics.getServer();
            HashMap<UUID, String> playerNames = new HashMap<UUID, String>();
            if (history != null && server != null && (cache = server.m_129927_()) != null) {
                for (UUID id : history.playerMap().values()) {
                    cache.m_11002_(id).ifPresent(profile -> {
                        String name = profile.getName();
                        if (name != null && !name.isEmpty()) {
                            playerNames.put(id, name);
                        }
                    });
                }
            }
            return Optional.of(new OpenSalesLedgerScreen(stack, playerNames));
        }

        public void send(ServerPlayer player) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)this);
        }

        public static class Handler {
            public static void handle(OpenSalesLedgerScreen packet) {
                if (Minecraft.m_91087_().f_91074_ == null) {
                    return;
                }
                Minecraft.m_91087_().m_91152_((Screen)new SalesLedgerScreen(packet.stack, packet.playerNames));
            }
        }
    }

    public static class ConfigureFlexibleShaft
    implements ServerboundPacket,
    CALPacket {
        public static final ResourceLocation ID = CreateAdditionalLogistics.asResource("configure_flexible_shaft");
        public final BlockPos pos;
        public final Direction side;
        public final byte mode;

        public static ConfigureFlexibleShaft of(BlockPos pos, Direction side, byte mode) {
            return new ConfigureFlexibleShaft(pos, side, mode);
        }

        public ConfigureFlexibleShaft(BlockPos pos, Direction side, byte mode) {
            this.pos = pos;
            this.side = side;
            this.mode = mode;
        }

        public ConfigureFlexibleShaft(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
            this.side = (Direction)buffer.m_130066_(Direction.class);
            this.mode = buffer.readByte();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
            buffer.m_130068_((Enum)this.side);
            buffer.writeByte((int)this.mode);
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void handle(@Nullable MinecraftServer server, @Nullable ServerPlayer player) {
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (level == null || !level.m_46749_(this.pos)) {
                return;
            }
            BlockState state = level.m_8055_(this.pos);
            Block block = state.m_60734_();
            if (!(block instanceof AbstractFlexibleShaftBlock)) {
                return;
            }
            AbstractFlexibleShaftBlock fsb = (AbstractFlexibleShaftBlock)block;
            fsb.setSide((Level)level, this.pos, this.side, this.mode);
        }

        public void send() {
            INSTANCE.sendToServer((Object)this);
        }
    }

    public static class UpdateGaugePromiseLimit
    implements ServerboundPacket,
    CALPacket {
        public static final ResourceLocation ID = CreateAdditionalLogistics.asResource("update_gauge_promise_limit");
        public final FactoryPanelPosition pos;
        public final int limit;
        public final int additionalStock;

        public UpdateGaugePromiseLimit(FactoryPanelPosition pos, int limit, int additionalStock) {
            this.pos = pos;
            this.limit = limit;
            this.additionalStock = additionalStock;
        }

        public UpdateGaugePromiseLimit(FriendlyByteBuf buffer) {
            this.pos = FactoryPanelPosition.receive((FriendlyByteBuf)buffer);
            this.limit = buffer.readInt();
            this.additionalStock = buffer.readInt();
        }

        public void write(FriendlyByteBuf buffer) {
            this.pos.send(buffer);
            buffer.writeInt(this.limit);
            buffer.writeInt(this.additionalStock);
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void handle(@Nullable MinecraftServer server, @Nullable ServerPlayer player) {
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46749_(this.pos.pos())) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos.pos());
            if (!(blockEntity instanceof FactoryPanelBlockEntity)) {
                return;
            }
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
            FactoryPanelBehaviour behavior = (FactoryPanelBehaviour)be.panels.get(this.pos.slot());
            if (!(behavior instanceof IPromiseLimit)) {
                return;
            }
            IPromiseLimit ipl = (IPromiseLimit)behavior;
            boolean changed = false;
            if (ipl.getCALPromiseLimit() != this.limit) {
                changed = true;
                ipl.setCALPromiseLimit(this.limit);
            }
            if (ipl.getCALAdditionalStock() != this.additionalStock) {
                changed = true;
                ipl.setCALAdditionalStock(this.additionalStock);
            }
            if (changed) {
                be.notifyUpdate();
            }
        }

        public void send() {
            INSTANCE.sendToServer((Object)this);
        }
    }

    public static interface CALPacket {
        default public boolean runOnMainThread() {
            return true;
        }
    }
}

