/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.common.utilities.SidedCache;
import dev.khloeleclair.create.additionallogistics.common.utilities.SimpleCurrency;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class RecipeHelper {
    public static RecipeCache getCache() {
        return SidedCache.getCache(RecipeCache.class);
    }

    public static void onRecipesUpdated(RecipesUpdatedEvent ignoredEvent) {
        SidedCache.runOnEachCache(RecipeCache.class, RecipeCache::clearCache);
    }

    @Nullable
    public static SimpleCurrency getCompactingCurrency(Item input) {
        return RecipeHelper.getCache().getCompactingCurrency(input);
    }

    public static <C extends Container, T extends Recipe<C>> List<T> safeGetRecipesFor(RecipeType<T> recipeType, C inventory, Level level) {
        try {
            return level.m_7465_().m_44056_(recipeType, inventory, level);
        }
        catch (Exception e) {
            CreateAdditionalLogistics.LOGGER.error("Error while getting recipe: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static class RecipeCache
    extends SidedCache {
        private final Map<Item, Optional<SimpleCurrency>> compactingCurrencies = new Object2ObjectOpenHashMap();

        public RecipeCache(boolean isServer) {
            super(isServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Map<Item, Optional<SimpleCurrency>> map = this.compactingCurrencies;
            synchronized (map) {
                this.compactingCurrencies.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public SimpleCurrency getCompactingCurrency(Item item) {
            SimpleCurrency currency;
            Optional<SimpleCurrency> cached;
            Map<Item, Optional<SimpleCurrency>> map = this.compactingCurrencies;
            synchronized (map) {
                cached = this.compactingCurrencies.get(item);
                if (cached != null) {
                    return cached.orElse(null);
                }
            }
            try {
                currency = this.getCompactingCurrencyImpl(item);
            }
            catch (Exception ex) {
                CreateAdditionalLogistics.LOGGER.warn("Error while determining automatic compacting currency for item {}", (Object)item);
                currency = null;
            }
            cached = Optional.ofNullable(currency);
            Map<Item, Optional<SimpleCurrency>> map2 = this.compactingCurrencies;
            synchronized (map2) {
                if (currency == null) {
                    this.compactingCurrencies.put(item, cached);
                } else {
                    for (Item i : currency.getItems()) {
                        this.compactingCurrencies.put(i, cached);
                    }
                }
            }
            return currency;
        }

        @Nullable
        private SimpleCurrency getCompactingCurrencyImpl(Item item) {
            ResourceLocation id;
            int count;
            ItemStack result;
            Level level = this.getLevel();
            if (level == null) {
                return null;
            }
            ArrayList<Pair> decompression = new ArrayList<Pair>();
            ArrayList<Pair> compression = new ArrayList<Pair>();
            HashSet<Item> visited = new HashSet<Item>();
            visited.add(item);
            Item current = item;
            while (!(result = RecipeCache.getUncompressResult(level, current.m_7968_())).m_41619_() && ((count = result.m_41613_()) == 4 || count == 9) && visited.add(result.m_41720_())) {
                List<ItemStack> compressionResult = RecipeCache.getCompressionResult(level, result, count == 4 ? 2 : 3);
                Item finalCurrent = current;
                if (compressionResult.stream().noneMatch(x -> x.m_150930_(finalCurrent) && x.m_41613_() == 1)) break;
                current = result.m_41720_();
                decompression.add(Pair.of((Object)current, (Object)count));
            }
            LinkedList<Item> frontier = new LinkedList<Item>();
            frontier.add(item);
            while (!frontier.isEmpty()) {
                current = (Item)frontier.remove(0);
                for (int size = 2; size <= 3; ++size) {
                    for (ItemStack result2 : RecipeCache.getCompressionResult(level, current.m_7968_(), size)) {
                        ItemStack uncompressResult;
                        if (result2.m_41619_() || result2.m_41613_() != 1 || !visited.add(result2.m_41720_()) || (uncompressResult = RecipeCache.getUncompressResult(level, result2)).m_41619_() || uncompressResult.m_41613_() != (size == 2 ? 4 : 9) || !uncompressResult.m_150930_(current)) continue;
                        frontier.add(result2.m_41720_());
                        compression.add(Pair.of((Object)result2.m_41720_(), (Object)(size == 2 ? 4 : 9)));
                    }
                }
            }
            if (decompression.isEmpty() && compression.isEmpty()) {
                return null;
            }
            @Nullable ResourceKey key = decompression.isEmpty() ? item.m_204114_().m_205785_() : ((Item)((Pair)decompression.get(decompression.size() - 1)).getFirst()).m_204114_().m_205785_();
            ResourceLocation resourceLocation = id = key == null ? null : key.m_135782_();
            if (id == null) {
                return null;
            }
            SimpleCurrency currency = new SimpleCurrency(new ResourceLocation(id.m_135827_(), "generated/" + id.m_135815_()));
            long value = 1L;
            for (int i = decompression.size() - 1; i >= 0; --i) {
                Pair entry = (Pair)decompression.get(i);
                currency.addItem((Item)entry.getFirst(), value);
                value *= (long)((Integer)entry.getSecond()).intValue();
            }
            currency.addItem(item, value);
            for (Pair entry : compression) {
                currency.addItem((Item)entry.getFirst(), value *= (long)((Integer)entry.getSecond()).intValue());
            }
            return currency;
        }

        private static CraftingContainer getContainerOf(int width, int height, ItemStack item) {
            TransientCraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                public ItemStack m_7648_(Player player, int i) {
                    return ItemStack.f_41583_;
                }

                public boolean m_6875_(Player player) {
                    return false;
                }
            }, width, height);
            for (int slot = 0; slot < inv.m_6643_(); ++slot) {
                inv.m_6836_(slot, item.m_255036_(1));
            }
            return inv;
        }

        private static List<ItemStack> getCompressionResult(Level level, ItemStack input, int size) {
            CraftingContainer inputGrid = RecipeCache.getContainerOf(size, size, input);
            List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, inputGrid, level);
            if (recipes.isEmpty()) {
                return List.of();
            }
            return recipes.stream().map(x -> x.m_8043_(level.m_9598_())).toList();
        }

        private static ItemStack getUncompressResult(Level level, ItemStack input) {
            CraftingContainer inputGrid = RecipeCache.getContainerOf(1, 1, input);
            List recipes = RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, inputGrid, level);
            if (recipes.size() != 1) {
                return ItemStack.f_41583_;
            }
            return ((CraftingRecipe)recipes.get(0)).m_8043_(level.m_9598_());
        }
    }
}

