/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.Nullable;

public class SidedCache {
    private static final Map<Class<?>, SidedCache> CLIENT_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<Class<?>, SidedCache> SERVER_CACHE = new Object2ObjectOpenHashMap();
    public final boolean isServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SidedCache> void runOnEachCache(Class<T> type, Consumer<T> method) {
        SidedCache cached;
        Map<Class<?>, SidedCache> map = CLIENT_CACHE;
        synchronized (map) {
            cached = CLIENT_CACHE.get(type);
            if (cached != null) {
                method.accept(cached);
            }
        }
        map = SERVER_CACHE;
        synchronized (map) {
            cached = SERVER_CACHE.get(type);
            if (cached != null) {
                method.accept(cached);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SidedCache> T getCache(Class<T> type) {
        Map<Class<?>, SidedCache> map;
        boolean is_server = Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
        Map<Class<?>, SidedCache> map2 = map = is_server ? SERVER_CACHE : CLIENT_CACHE;
        synchronized (map2) {
            SidedCache cached = map.get(type);
            if (cached != null) {
                return (T)cached;
            }
            try {
                cached = (SidedCache)type.getDeclaredConstructor(Boolean.TYPE).newInstance(is_server);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to create cache for type: " + type.getName(), ex);
            }
            map.put(type, cached);
            return (T)cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends SidedCache> T getCacheIfInitialized(Class<T> type) {
        Map<Class<?>, SidedCache> map;
        boolean is_server = Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
        Map<Class<?>, SidedCache> map2 = map = is_server ? SERVER_CACHE : CLIENT_CACHE;
        synchronized (map2) {
            SidedCache cached = map.get(type);
            if (cached != null) {
                return (T)cached;
            }
        }
        return null;
    }

    public SidedCache(boolean isServer) {
        this.isServer = isServer;
    }

    @Nullable
    public Level getLevel() {
        return this.isServer ? SidedCache.getServerLevel() : SidedCache.getClientLevel();
    }

    @Nullable
    private static Level getServerLevel() {
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        return server == null ? null : server.m_129783_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

