/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.utilities;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import dev.khloeleclair.create.additionallogistics.api.ICurrency;
import dev.khloeleclair.create.additionallogistics.api.ICurrencyBuilder;
import dev.khloeleclair.create.additionallogistics.common.utilities.CurrencyUtilities;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SimpleCurrency
implements ICurrency {
    private final ResourceLocation id;
    private final Map<Item, Long> items;
    private final Map<Item, Pair<ICurrency.IAdvancedValueGetter, ICurrency.IAdvancedValueExtractor>> advancedItems;
    private final List<Item> items_by_value;

    public SimpleCurrency(ResourceLocation id) {
        this.id = id;
        this.items = new Object2LongArrayMap();
        this.advancedItems = new Object2ObjectArrayMap();
        this.items_by_value = new ArrayList<Item>();
    }

    public void addItem(Item item, long value) {
        Objects.requireNonNull(item);
        if (value <= 0L) {
            throw new IllegalArgumentException("value must be greater than 0");
        }
        if (this.advancedItems.containsKey(item)) {
            throw new IllegalArgumentException("item " + item.m_5524_() + " has advanced definition");
        }
        this.items.put(item, value);
        this.items_by_value.add(item);
        this.items_by_value.sort((a, b) -> -this.items.get(a).compareTo(this.items.get(b)));
    }

    public void addItem(Item item, ICurrency.IAdvancedValueGetter getValue, ICurrency.IAdvancedValueExtractor extractValue) {
        Objects.requireNonNull(item);
        Objects.requireNonNull(getValue);
        Objects.requireNonNull(extractValue);
        if (this.items.containsKey(item)) {
            this.items.remove(item);
            this.items_by_value.remove(item);
        }
        this.advancedItems.put(item, (Pair<ICurrency.IAdvancedValueGetter, ICurrency.IAdvancedValueExtractor>)Pair.of((Object)getValue, (Object)extractValue));
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Iterable<Item> getItems() {
        return Iterables.concat(this.items.keySet(), this.advancedItems.keySet());
    }

    public void validate() {
        if (this.items.isEmpty()) {
            throw new IllegalStateException("currency must have at least one non-advanced item");
        }
    }

    @Override
    public long getValue(@Nullable Player player, ItemStack stack, int count) {
        Item item = stack.m_41720_();
        Pair<ICurrency.IAdvancedValueGetter, ICurrency.IAdvancedValueExtractor> advanced = this.advancedItems.get(item);
        if (advanced != null) {
            return ((ICurrency.IAdvancedValueGetter)advanced.first()).get(player, stack, count);
        }
        long value = this.items.getOrDefault(item, 0L);
        return value * (long)count;
    }

    @Override
    public List<ItemStack> getStacksWithValue(long value) {
        long remaining = value;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item item : this.items_by_value) {
            long item_value = this.items.get(item);
            if (item_value > remaining) continue;
            long item_amount = remaining / item_value;
            remaining -= item_amount * item_value;
            int max_stack = item.m_41459_();
            while (item_amount > 0L) {
                int count = Math.min(max_stack, item_amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)item_amount);
                item_amount -= (long)count;
                result.add(new ItemStack((ItemLike)item, count));
            }
        }
        return result;
    }

    @Override
    public ICurrency.ExtractionResult extractValue(@Nullable Player player, ItemStack stack, long toExtract, boolean exact) {
        Item item = stack.m_41720_();
        Pair<ICurrency.IAdvancedValueGetter, ICurrency.IAdvancedValueExtractor> adv = this.advancedItems.get(item);
        if (adv != null) {
            return ((ICurrency.IAdvancedValueExtractor)adv.second()).apply(player, stack, toExtract, exact);
        }
        int count = stack.m_41613_();
        long value = this.getValue(player, stack, count);
        if (toExtract <= 0L || value <= 0L || stack.m_41619_()) {
            return new ICurrency.ExtractionResult(List.of(stack), toExtract);
        }
        if (toExtract >= value) {
            return new ICurrency.ExtractionResult(List.of(), toExtract - value);
        }
        long item_value = this.items.get(stack.m_41720_());
        if (exact) {
            long desired = toExtract / item_value;
            int amount = Math.min(count, Ints.saturatedCast((long)desired));
            long remaining = toExtract - (long)amount * item_value;
            if (amount == count) {
                return new ICurrency.ExtractionResult(List.of(), remaining);
            }
            if (amount == 0) {
                return new ICurrency.ExtractionResult(List.of(stack), remaining);
            }
            return new ICurrency.ExtractionResult(List.of(stack.m_255036_(count - amount)), remaining);
        }
        long remaining = value - toExtract;
        return new ICurrency.ExtractionResult(this.getStacksWithValue(remaining), 0L);
    }

    @Override
    @Nullable
    public Component formatValue(long value, TooltipFlag flag) {
        ICurrency.IValueFormatter formatter = CurrencyUtilities.getFormatter(this.id);
        if (formatter != null) {
            return formatter.get(value, flag);
        }
        return null;
    }

    public static class CurrencyBuilder
    implements ICurrencyBuilder {
        private final SimpleCurrency currency;
        private final ICurrency.ICurrencyBackend backend;
        @Nullable
        private ICurrency.IValueFormatter formatter;

        public CurrencyBuilder(ResourceLocation id, ICurrency.ICurrencyBackend backend) {
            this.backend = backend;
            this.currency = new SimpleCurrency(id);
        }

        @Override
        public CurrencyBuilder add(Item item, int value) {
            return this.add(item, (long)value);
        }

        @Override
        public CurrencyBuilder add(Item item, long value) {
            if (item.equals(Items.f_41852_)) {
                throw new IllegalArgumentException("item cannot be air");
            }
            if (value < 1L) {
                throw new IllegalArgumentException("value must be at least 1");
            }
            this.currency.addItem(item, value);
            return this;
        }

        @Override
        public ICurrencyBuilder add(Item item, ICurrency.IAdvancedValueGetter getValue, ICurrency.IAdvancedValueExtractor extractValue) {
            Objects.requireNonNull(item);
            Objects.requireNonNull(getValue);
            Objects.requireNonNull(extractValue);
            if (item.equals(Items.f_41852_)) {
                throw new IllegalArgumentException("item cannot be air");
            }
            this.currency.addItem(item, getValue, extractValue);
            return this;
        }

        @Override
        public CurrencyBuilder formatter(ICurrency.IValueFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public ICurrency build() {
            this.currency.validate();
            this.backend.registerCurrency(this.currency.getId(), this.currency);
            if (this.formatter != null) {
                this.backend.registerFormatter(this.currency.getId(), this.formatter);
            }
            return this.currency;
        }
    }
}

