/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.ComputerUtil;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaComparable;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaPostboxObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaTrainObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaWriteableStationObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class LuaStationObject
implements LuaComparable {
    protected final GlobalStation station;

    protected LuaStationObject(GlobalStation station) {
        this.station = station;
    }

    public static LuaStationObject of(GlobalStation station, boolean writeable) {
        return writeable ? new LuaWriteableStationObject(station) : new LuaStationObject(station);
    }

    protected boolean isWritable() {
        return false;
    }

    protected void assertTrainPresent() throws LuaException {
        if (this.station.getPresentTrain() == null) {
            throw new LuaException("there is no train present");
        }
    }

    @Nullable
    protected Level getLevel() {
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        if (server == null) {
            return null;
        }
        return server.m_129880_(this.station.blockEntityDimension);
    }

    @Nullable
    protected StationBlockEntity getBlockEntity() {
        BlockEntity blockEntity;
        Level level = this.getLevel();
        if (level == null || !level.m_46749_(this.station.blockEntityPos) || !((blockEntity = level.m_7702_(this.station.blockEntityPos)) instanceof StationBlockEntity)) {
            return null;
        }
        StationBlockEntity sbe = (StationBlockEntity)blockEntity;
        return sbe;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getPosition() {
        return ComputerUtil.getPosition(this.station.blockEntityPos, (ResourceKey<Level>)this.station.blockEntityDimension);
    }

    @LuaFunction(mainThread=true)
    public final String getName() {
        return this.station.name;
    }

    @LuaFunction(mainThread=true)
    public final String getId() {
        return this.station.id.toString();
    }

    @LuaFunction(mainThread=true)
    public final boolean isLoaded() {
        return this.getBlockEntity() != null;
    }

    @LuaFunction(mainThread=true)
    public final boolean isInAssemblyMode() {
        return this.station.assembling;
    }

    @LuaFunction(mainThread=true)
    public final boolean isTrainPresent() {
        return this.station.getPresentTrain() != null;
    }

    @LuaFunction(mainThread=true)
    public final boolean isTrainImminent() {
        return this.station.getImminentTrain() != null;
    }

    @LuaFunction(mainThread=true)
    public final boolean isTrainEnroute() {
        return this.station.getNearestTrain() != null;
    }

    @LuaFunction(mainThread=true)
    public final int sizePostboxes() {
        return this.station.connectedPorts.size();
    }

    @LuaFunction(mainThread=true)
    public final LuaPostboxObject getPostbox(int slot) throws LuaException {
        int i = 0;
        for (Map.Entry portEntry : this.station.connectedPorts.entrySet()) {
            if (++i != slot) continue;
            return LuaPostboxObject.of(this.station, (BlockPos)portEntry.getKey(), (GlobalPackagePort)portEntry.getValue(), this.isWritable());
        }
        throw new LuaException("Slot " + slot + " out of range, expected between 1 and " + this.station.connectedPorts.size());
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final LuaTrainObject getTrain() {
        Train train = this.station.getPresentTrain();
        if (train == null) {
            return null;
        }
        return LuaTrainObject.of(train, this.isWritable());
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        HashMap<String, UUID> result = new HashMap<String, UUID>();
        result.put("id", this.station.id);
        return result;
    }
}

