/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.ComputerUtil;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaSalesHistoryObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class CashRegisterPeripheral
extends SyncedPeripheral<CashRegisterBlockEntity> {
    public CashRegisterPeripheral(CashRegisterBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Map<String, ?>> stock(Optional<Boolean> detailed) {
        HashMap result = new HashMap();
        int i = 0;
        for (BigItemStack entry : ((CashRegisterBlockEntity)this.blockEntity).getAccurateSummary().getStacks()) {
            HashMap<String, Integer> details = new HashMap<String, Integer>(detailed.isPresent() && detailed.get() != false ? VanillaDetailRegistries.ITEM_STACK.getDetails((Object)entry.stack) : VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)entry.stack));
            details.put("count", entry.count);
            result.put(++i, details);
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, ?> getStockItemDetail(int slot) throws LuaException {
        return ComputerUtil.getItemDetail(((CashRegisterBlockEntity)this.blockEntity).getAccurateSummary(), slot);
    }

    @LuaFunction(mainThread=true)
    public final int requestFiltered(String address, IArguments filters) throws LuaException {
        ArrayList<BigItemStack> validItems = new ArrayList<BigItemStack>();
        int totalItemsSent = 0;
        List stock = ((CashRegisterBlockEntity)this.blockEntity).getAccurateSummary().getStacks();
        block0: for (int i = 1; i < filters.count(); ++i) {
            Iterator iterator = filters.get(i);
            if (!(iterator instanceof Map)) {
                throw new LuaException("Filter must be a table");
            }
            Map filterTable = (Map)((Object)iterator);
            for (Object key : filterTable.keySet()) {
                if (key instanceof String) continue;
                throw new LuaException("Filter keys must be strings");
            }
            Map filter = filterTable;
            int itemsRequested = Integer.MAX_VALUE;
            if (filterTable.containsKey("_requestCount")) {
                Object requestCount = filterTable.get("_requestCount");
                filterTable.remove("_requestCount");
                if (requestCount instanceof Number) {
                    itemsRequested = ((Number)requestCount).intValue();
                    if (itemsRequested < 1) {
                        throw new LuaException("_requestCount must be a positive number or nil for no limit");
                    }
                } else {
                    throw new LuaException("_requestCount must be a positive number or nil for no limit");
                }
            }
            for (BigItemStack entry : stock) {
                int foundItems = ComputerUtil.bigItemStackToLuaTableFilter(entry, filter);
                if (foundItems > 0) {
                    int toTake = Math.min(foundItems, itemsRequested);
                    itemsRequested -= toTake;
                    totalItemsSent += toTake;
                    BigItemStack requestedItem = new BigItemStack(entry.stack.m_41777_(), toTake);
                    entry.count -= toTake;
                    validItems.add(requestedItem);
                }
                if (itemsRequested > 0) continue;
                continue block0;
            }
        }
        PackageOrder order = new PackageOrder(validItems);
        ((CashRegisterBlockEntity)this.blockEntity).broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.RESTOCK, order, null, address);
        return totalItemsSent;
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Map<String, ?>> list() {
        return ComputerUtil.list((IItemHandler)((CashRegisterBlockEntity)this.blockEntity).getReceivedPaymentsHandler());
    }

    @LuaFunction(mainThread=true)
    public final Map<String, ?> getItemDetail(int slot) throws LuaException {
        return ComputerUtil.getItemDetail((IItemHandler)((CashRegisterBlockEntity)this.blockEntity).getReceivedPaymentsHandler(), slot);
    }

    @LuaFunction(mainThread=true)
    public final LuaSalesHistoryObject getSales() {
        ItemStack ledger = ((CashRegisterBlockEntity)this.blockEntity).getLedger();
        return new LuaSalesHistoryObject(SalesHistoryData.getOrEmpty(ledger));
    }

    @LuaFunction(mainThread=true)
    public final Map<String, ?> getLedger() throws LuaException {
        return VanillaDetailRegistries.ITEM_STACK.getDetails((Object)((CashRegisterBlockEntity)this.blockEntity).getLedger());
    }

    public String getType() {
        return "CreateAdditionalLogistics_CashRegister";
    }

    @Nullable
    public Object getTarget() {
        return this.blockEntity;
    }
}

