/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.content.trains.networkMonitor;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Affine;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitor;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitorBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitorVisual
extends AbstractBlockEntityVisual<NetworkMonitorBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance overlay;

    public NetworkMonitorVisual(VisualizationContext ctx, NetworkMonitorBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.overlay = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.TRACK_OBSERVER_OVERLAY)).createInstance();
    }

    public void tick(TickableVisual.Context context) {
        TrackTargetingBehaviour<NetworkMonitor> target = ((NetworkMonitorBlockEntity)this.blockEntity).edgePoint;
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = ((NetworkMonitorBlockEntity)this.blockEntity).m_58904_();
        BlockState trackState = level.m_8055_(targetPosition);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            this.overlay.setZeroTransform().setChanged();
            return;
        }
        ITrackBlock trackBlock = (ITrackBlock)block;
        this.overlay.setIdentityTransform().translate((Vec3i)targetPosition);
        TrackTargetingBehaviour.RenderedTrackOverlayType type = TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER;
        trackBlock.prepareTrackOverlay((Affine)this.overlay, (BlockGetter)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
        this.overlay.setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.overlay});
    }

    protected void _delete() {
        this.overlay.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.overlay);
    }
}

