/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible;

import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.flexible.FlexibleShaftBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import dev.khloeleclair.create.additionallogistics.mixin.RotationPropagatorInvoker;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlexibleShaftBlock
extends AbstractLowEntityKineticBlock<FlexibleShaftBlockEntity> {
    public static final BooleanProperty[] SIDES = new BooleanProperty[]{BooleanProperty.m_61465_((String)"down"), BooleanProperty.m_61465_((String)"up"), BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_};
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    @Nullable
    protected final DyeColor color;

    protected AbstractFlexibleShaftBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color) {
        super(properties);
        this.color = color;
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        if (state.m_61138_((Property)ProperWaterloggedBlock.WATERLOGGED)) {
            state = (BlockState)state.m_61124_((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        for (BooleanProperty side : SIDES) {
            state = (BlockState)state.m_61124_((Property)side, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_((Property[])SIDES);
        builder.m_61104_(new Property[]{ACTIVE});
        if (this instanceof ProperWaterloggedBlock) {
            builder.m_61104_(new Property[]{ProperWaterloggedBlock.WATERLOGGED});
        }
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE);
    }

    @Override
    @Nullable
    public DyeColor getColor(BlockState state) {
        return this.color;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.m_61124_((Property)SIDES[mirror.m_54848_(dir).ordinal()], (Comparable)((Boolean)state.m_61143_((Property)SIDES[dir.ordinal()])));
        }
        return newState;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BlockState newState = state;
        for (Direction dir : Iterate.directions) {
            newState = (BlockState)newState.m_61124_((Property)SIDES[rotation.m_55954_(dir).ordinal()], (Comparable)((Boolean)state.m_61143_((Property)SIDES[dir.ordinal()])));
        }
        return newState;
    }

    protected BlockState getConnectedState(Level level, BlockPos pos, BlockState initialState) {
        BlockState state = initialState;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            BlockPos dpos = pos.m_121945_(dir);
            BlockState dstate = level.m_8055_(dpos);
            boolean connects = this.connectsTo((LevelAccessor)level, pos, state, dir, dpos, dstate);
            state = (BlockState)state.m_61124_((Property)SIDES[index], (Comparable)Boolean.valueOf(connects));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return this.getConnectedState(level, pos, super.m_5573_(context));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        byte key = 0;
        for (Direction dir : Iterate.directions) {
            int index = dir.ordinal();
            if (!((Boolean)state.m_61143_((Property)SIDES[index])).booleanValue()) continue;
            key = (byte)(key | 1 << index);
        }
        return this.getShapeWithSides(key);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty prop = SIDES[direction.ordinal()];
        boolean connects = this.connectsTo(level, pos, state, direction, neighborPos, level.m_8055_(neighborPos));
        if ((Boolean)state.m_61143_((Property)prop) != connects && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(connects));
            AbstractLowEntityKineticBlockEntity.markDirty((Level)sl, pos);
        }
        return state;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        BlockEntity blockEntity;
        if (!this.isActive(state) || !((blockEntity = world.m_7702_(pos)) instanceof FlexibleShaftBlockEntity)) {
            return false;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        return fsb.getSide(face) != 0;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player != null && player.m_36326_() && !(player instanceof FakePlayer) && player.m_21120_(hand).m_41619_()) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CALPackets.OpenFlexibleShaftScreen.of(pos).send(sp);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void setSide(Level level, BlockPos pos, Direction side, byte value) {
        BlockEntity blockEntity;
        if (level.f_46443_ || !level.m_46749_(pos)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (value == 0) {
                return;
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.m_7702_(pos)) instanceof FlexibleShaftBlockEntity)) {
            return;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        fsb.setSide(side, value);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IRotate rot;
        BlockPos offsetPos;
        BlockState offsetState;
        Block block;
        BlockEntity blockEntity;
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Direction side = context.m_43719_();
        if (((Boolean)state.m_61143_((Property)SIDES[side.ordinal()])).booleanValue() && !(this instanceof EncasedBlock)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            AbstractLowEntityKineticBlockEntity.markDirty(level, pos);
        }
        if (!((blockEntity = level.m_7702_(context.m_8083_())) instanceof FlexibleShaftBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        FlexibleShaftBlockEntity fsb = (FlexibleShaftBlockEntity)blockEntity;
        byte mode = fsb.getSide(side);
        if (mode == 0 && (block = (offsetState = level.m_8055_(offsetPos = pos.m_121945_(side))).m_60734_()) instanceof IRotate && (rot = (IRotate)block).hasShaftTowards((LevelReader)level, offsetPos, offsetState, side.m_122424_()) && (block = level.m_7702_(offsetPos)) instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)block;
            fsb.setSideUnsafe(side, (byte)1);
            float neighborSpeed = kbe.getTheoreticalSpeed();
            float newSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            float oppositeSpeed = RotationPropagatorInvoker.callGetConveyedSpeed((KineticBlockEntity)fsb, kbe);
            if (newSpeed != 0.0f && oppositeSpeed != 0.0f) {
                boolean incompatible;
                boolean bl = incompatible = Math.signum(newSpeed) != Math.signum(neighborSpeed) && newSpeed != 0.0f && neighborSpeed != 0.0f;
                if (incompatible) {
                    fsb.setSide(side, (byte)-1);
                    return InteractionResult.SUCCESS;
                }
            }
            fsb.setSideUnsafe(side, mode);
        }
        fsb.toggleSide(side);
        if (!fsb.shouldBeActive()) {
            fsb.deactivateSelf();
        }
        return InteractionResult.SUCCESS;
    }

    public Class<FlexibleShaftBlockEntity> getBlockEntityClass() {
        return FlexibleShaftBlockEntity.class;
    }

    public BlockEntityType<? extends FlexibleShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CALBlockEntityTypes.FLEXIBLE_SHAFT.get();
    }
}

