/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.api.ICurrency;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterBlock;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.CashRegisterMenu;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.common.utilities.CurrencyUtilities;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CashRegisterBlockEntity
extends StockTickerBlockEntity {
    public AbstractEventfulComputerBehavior computerBehavior;
    private ItemStack ledger = ItemStack.f_41583_;
    private final IItemHandlerModifiable ledgerHandler;
    public final CombinedInvWrapper invWrapper;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.playSound(blockState, AllSoundEvents.STOCK_TICKER_TRADE.getMainEvent());
            CashRegisterBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof CashRegisterMenu) {
                CashRegisterMenu menu = (CashRegisterMenu)abstractContainerMenu;
                return menu.contentHolder == CashRegisterBlockEntity.this;
            }
            return false;
        }
    };
    private final LazyOptional<IItemHandler> capability;
    private final LazyOptional<IItemHandler> ledgerCapability;
    private final LazyOptional<IItemHandler> combinedCapability;
    private int saleTicks = 0;

    public CashRegisterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.ledgerHandler = new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, ItemStack stack) {
                if (this.isItemValid(slot, stack)) {
                    CashRegisterBlockEntity.this.ledger = stack;
                }
            }

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return CashRegisterBlockEntity.this.ledger;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if ((CashRegisterBlockEntity.this.ledger == null || CashRegisterBlockEntity.this.ledger.m_41619_()) && this.isItemValid(slot, stack)) {
                    if (!simulate) {
                        CashRegisterBlockEntity.this.ledger = stack;
                    }
                    return ItemStack.f_41583_;
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 1 && amount < 1) {
                    return ItemStack.f_41583_;
                }
                ItemStack result = CashRegisterBlockEntity.this.ledger;
                if (!simulate) {
                    CashRegisterBlockEntity.this.ledger = ItemStack.f_41583_;
                }
                CashRegisterBlockEntity.this.notifyUpdate();
                return result;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : 0;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot != 0 || stack.m_41619_() || !stack.m_150930_((Item)CALItems.SALES_LEDGER.get()) || stack.m_41613_() != 1) {
                    return false;
                }
                SalesHistoryData history = SalesHistoryData.get(stack);
                return history == null || history.saleCount() < 1000;
            }
        };
        this.invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.receivedPayments, this.ledgerHandler});
        this.capability = LazyOptional.of(() -> this.receivedPayments);
        this.ledgerCapability = LazyOptional.of(() -> this.ledgerHandler);
        this.combinedCapability = LazyOptional.of(() -> this.invWrapper);
    }

    public void invalidate() {
        super.invalidate();
        this.computerBehavior.removePeripheral();
    }

    public boolean hadRecentSale() {
        return this.saleTicks > 0;
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)CashRegisterBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        if (this.f_58857_ == null) {
            return;
        }
        Vec3i face = ((Direction)state.m_61143_((Property)CashRegisterBlock.f_54117_)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)face.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)face.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)face.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.f_58858_, this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.ledger != null) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.f_58858_, this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_ && this.f_58857_ != null) {
            this.openersCounter.m_155476_(this.f_58857_, this.f_58858_, this.m_58900_());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return side == Direction.DOWN ? this.capability.cast() : (side == Direction.UP ? this.ledgerCapability.cast() : this.combinedCapability.cast());
        }
        if (this.computerBehavior.isPeripheralCap(cap)) {
            return this.computerBehavior.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.removeIf(x -> x instanceof AbstractComputerBehaviour);
        this.computerBehavior = CALComputerCraftProxy.behavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehavior);
    }

    public void tick() {
        super.tick();
        if (this.saleTicks > 0) {
            --this.saleTicks;
        }
    }

    public void destroy() {
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.ledgerHandler);
        super.destroy();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.ledger != null && !this.ledger.m_41619_()) {
            tag.m_128365_("Ledger", (Tag)this.ledger.m_41739_(new CompoundTag()));
        }
        tag.m_128405_("SaleTicks", this.saleTicks);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.ledger = ItemStack.f_41583_;
        if (tag.m_128425_("Ledger", 10)) {
            this.ledger = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Ledger"));
        }
        this.saleTicks = tag.m_128451_("SaleTicks");
    }

    public static void recordSale(Level level, BlockPos pos, Player player, ItemStack mainHandItem) {
        BlockEntity blockEntity;
        if (level.f_46443_ || mainHandItem.m_41619_() || !((blockEntity = level.m_7702_(pos)) instanceof CashRegisterBlockEntity)) {
            return;
        }
        CashRegisterBlockEntity be = (CashRegisterBlockEntity)blockEntity;
        if (player.m_21205_().equals(mainHandItem)) {
            return;
        }
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList((ItemStack)mainHandItem);
        if (list == null) {
            return;
        }
        be.recordSale(player, list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        SalesHistoryData history;
        if (this.receivedPayments.m_7983_() && this.ledger.m_41619_()) {
            return false;
        }
        if (!this.behaviour.mayAdministrate((Player)Minecraft.m_91087_().f_91074_)) {
            return false;
        }
        SalesHistoryData salesHistoryData = history = this.ledger.m_41619_() ? null : SalesHistoryData.get(this.ledger);
        if (history != null) {
            CALLang.translate("sales.sales", CALLang.number(history.saleCount()).style(ChatFormatting.GOLD)).style(ChatFormatting.WHITE).forGoggles(tooltip);
            MutableComponent cmp = history.getTimeRange(ChatFormatting.AQUA);
            if (cmp != null) {
                CALLang.builder().add(cmp.m_130940_(ChatFormatting.WHITE)).forGoggles(tooltip);
            }
            if (!this.receivedPayments.m_7983_()) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
        }
        if (!this.receivedPayments.m_7983_()) {
            CreateLang.translate((String)"stock_ticker.contains_payments", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
            InventorySummary summary = new InventorySummary();
            for (int i = 0; i < this.receivedPayments.getSlots(); ++i) {
                summary.add(this.receivedPayments.getStackInSlot(i));
            }
            Pair<Map<ICurrency, Long>, List<BigItemStack>> costs = CurrencyUtilities.splitCost(null, summary.getStacks());
            Map currency_costs = (Map)costs.getFirst();
            List other_costs = (List)costs.getSecond();
            Options options = Minecraft.m_91087_().f_91066_;
            TooltipFlag.Default tooltipFlags = options.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
            for (Map.Entry entry : currency_costs.entrySet()) {
                Component cmp;
                ICurrency currency = (ICurrency)entry.getKey();
                try {
                    cmp = currency.formatValue((Long)entry.getValue(), (TooltipFlag)tooltipFlags);
                }
                catch (Exception ex) {
                    CreateAdditionalLogistics.LOGGER.error("Error running currency formatter for {}", (Object)currency.getId(), (Object)ex);
                    cmp = null;
                }
                if (cmp != null) {
                    CreateLang.builder().add(cmp).style(ChatFormatting.GREEN).forGoggles(tooltip);
                    continue;
                }
                for (ItemStack stack : currency.getStacksWithValue((Long)entry.getValue())) {
                    CreateLang.builder().text(Component.m_237115_((String)stack.m_41778_()).getString() + " x" + stack.m_41613_()).style(ChatFormatting.GREEN).forGoggles(tooltip);
                }
            }
            for (BigItemStack bigItemStack : other_costs) {
                CreateLang.builder().text(Component.m_237115_((String)bigItemStack.stack.m_41778_()).getString() + " x" + bigItemStack.count).style(ChatFormatting.GREEN).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void recordSale(Player player, ShoppingListItem.ShoppingList list) {
        SalesHistoryData history;
        Couple baked = list.bakeEntries((LevelAccessor)this.f_58857_, null);
        InventorySummary payment = (InventorySummary)baked.getSecond();
        InventorySummary order = (InventorySummary)baked.getFirst();
        SalesHistoryData salesHistoryData = history = this.ledger.m_41619_() ? null : SalesHistoryData.get(this.ledger);
        if (history == null) {
            history = SalesHistoryData.EMPTY;
        }
        if (history.saleCount() >= 1000) {
            this.ledger = ItemHandlerHelper.insertItem((IItemHandler)this.receivedPayments, (ItemStack)this.ledger, (boolean)false);
            if (this.ledger.m_41619_()) {
                history = SalesHistoryData.EMPTY;
            } else {
                return;
            }
        }
        SalesHistoryData result = history.withBigSale(player.m_20148_(), payment.getStacks(), order.getStacks());
        this.computerBehavior.queuePositionedEvent("sale", Pair.of((Object)history, (Object)history.lastSale()));
        if (this.ledger.m_41619_()) {
            this.ledger = CALItems.SALES_LEDGER.asStack();
        }
        result.save(this.ledger);
        this.reconcileCurrency();
        this.saleTicks = 20;
        this.notifyUpdate();
    }

    public void reconcileCurrency() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Object2LongArrayMap currencies = new Object2LongArrayMap();
        IntArrayList slots = new IntArrayList();
        int empty_slots = 0;
        for (int slot = 0; slot < this.receivedPayments.getSlots(); ++slot) {
            ItemStack stack = this.receivedPayments.getStackInSlot(slot);
            if (stack.m_41619_()) {
                ++empty_slots;
                continue;
            }
            ICurrency iterator = CurrencyUtilities.getForItem(stack.m_41720_());
            if (iterator == null) continue;
            currencies.put(iterator, currencies.getOrDefault(iterator, 0L) + iterator.getValue(null, stack, stack.m_41613_()));
            slots.add(slot);
        }
        if (currencies.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry entry : currencies.entrySet()) {
            stacks.addAll(((ICurrency)entry.getKey()).getStacksWithValue((Long)entry.getValue()));
        }
        int available_slots = empty_slots + slots.size();
        if (available_slots < stacks.size()) {
            return;
        }
        Iterator iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.receivedPayments.setStackInSlot(slot, ItemStack.f_41583_);
        }
        for (ItemStack stack : stacks) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.receivedPayments, (ItemStack)stack, (boolean)false);
            if (remainder.m_41619_()) continue;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)this.f_58858_.m_123343_(), remainder);
            entity.m_32010_(40);
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    public SmartInventory getReceivedPaymentsHandler() {
        return this.receivedPayments;
    }

    public ItemStack getLedger() {
        return this.ledger;
    }

    public class CashRegisterMenuProvider
    implements MenuProvider {
        @Nullable
        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return CashRegisterMenu.create(id, inventory, CashRegisterBlockEntity.this);
        }

        public Component m_5446_() {
            return CashRegisterBlockEntity.this.m_58900_().m_60734_().m_49954_();
        }
    }
}

