/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SalesLedgerItem
extends Item {
    public SalesLedgerItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        SalesHistoryData data = SalesHistoryData.get(stack);
        if (data == null) {
            return;
        }
        tooltipComponents.add((Component)CALLang.translate("sales.entries", CALLang.number(data.saleCount()).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).component());
        MutableComponent cmp = data.getTimeRange(ChatFormatting.AQUA);
        if (cmp != null) {
            tooltipComponents.add((Component)cmp.m_130940_(ChatFormatting.GRAY));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) != 0;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getDamage(ItemStack stack) {
        SalesHistoryData history = SalesHistoryData.get(stack);
        return history == null ? 0 : history.saleCount();
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CALPackets.OpenSalesLedgerScreen.create(heldItem).ifPresent(p -> p.send(sp));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }
}

