/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor;

import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.khloeleclair.create.additionallogistics.common.content.trains.networkMonitor.NetworkMonitor;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.AbstractEventfulComputerBehavior;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitorBlockEntity
extends SmartBlockEntity {
    public TrackTargetingBehaviour<NetworkMonitor> edgePoint;
    public AbstractEventfulComputerBehavior computerBehavior;

    public NetworkMonitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, NetworkMonitor.NETWORK_MONITOR);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
        this.computerBehavior = CALComputerCraftProxy.behavior(this);
        behaviours.add((BlockEntityBehaviour)this.computerBehavior);
    }

    public void invalidate() {
        super.invalidate();
        this.computerBehavior.removePeripheral();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerBehavior.isPeripheralCap(cap)) {
            return this.computerBehavior.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void onTrainArrival(UUID train, UUID station) {
        this.computerBehavior.queuePositionedEvent("train_arrival", train.toString(), station.toString());
    }

    public void onTrainDeparture(UUID train) {
        this.computerBehavior.queuePositionedEvent("train_departure", train.toString());
    }
}

