/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.GlobalStation;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.khloeleclair.create.additionallogistics.CreateAdditionalLogistics;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.ComputerUtil;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaComparable;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaStationObject;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.implementation.luaObjects.LuaWriteablePostboxObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class LuaPostboxObject
implements LuaComparable {
    protected final GlobalStation station;
    protected final BlockPos pos;
    protected final GlobalPackagePort port;

    protected LuaPostboxObject(GlobalStation station, BlockPos pos, GlobalPackagePort port) {
        this.station = station;
        this.pos = pos;
        this.port = port;
    }

    public static LuaPostboxObject of(GlobalStation station, BlockPos pos, GlobalPackagePort port, boolean writeable) {
        return writeable ? new LuaWriteablePostboxObject(station, pos, port) : new LuaPostboxObject(station, pos, port);
    }

    protected boolean isWriteable() {
        return false;
    }

    @Nullable
    protected Level getLevel() {
        MinecraftServer server = CreateAdditionalLogistics.getServer();
        if (server == null) {
            return null;
        }
        return server.m_129880_(this.station.blockEntityDimension);
    }

    @Nullable
    protected PostboxBlockEntity getBlockEntity() {
        BlockEntity blockEntity;
        Level level = this.getLevel();
        if (level == null || !level.m_46749_(this.pos) || !((blockEntity = level.m_7702_(this.pos)) instanceof PostboxBlockEntity)) {
            return null;
        }
        PostboxBlockEntity pbbe = (PostboxBlockEntity)blockEntity;
        return pbbe;
    }

    protected IItemHandlerModifiable getInventory() {
        PostboxBlockEntity ppbe = this.getBlockEntity();
        if (ppbe == null || this.port.primed) {
            return this.port.offlineBuffer;
        }
        return ppbe.inventory;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getPosition() {
        return ComputerUtil.getPosition(this.pos, (ResourceKey<Level>)this.station.blockEntityDimension);
    }

    @LuaFunction(mainThread=true)
    public final String getAddress() {
        return this.port.address;
    }

    @LuaFunction(mainThread=true)
    public final boolean isLoaded() {
        return this.getBlockEntity() != null;
    }

    @LuaFunction(mainThread=true)
    public final boolean hasIncomingPackages() {
        IItemHandlerModifiable inv = this.getInventory();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!PackageItem.isPackage((ItemStack)stack) || !PackageItem.matchAddress((ItemStack)stack, (String)this.port.address)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean hasOutgoingPackages() {
        IItemHandlerModifiable inv = this.getInventory();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!PackageItem.isPackage((ItemStack)stack) || PackageItem.matchAddress((ItemStack)stack, (String)this.port.address)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Integer> listPackageDestinations() {
        IItemHandlerModifiable inv = this.getInventory();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            String boxAddress;
            ItemStack stack = inv.getStackInSlot(slot);
            if (!PackageItem.isPackage((ItemStack)stack) || PackageItem.matchAddress((String)(boxAddress = PackageItem.getAddress((ItemStack)stack)), (String)this.port.address)) continue;
            result.put(boxAddress, result.getOrDefault(boxAddress, 0) + 1);
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final LuaStationObject getStation() {
        return LuaStationObject.of(this.station, this.isWriteable());
    }

    @LuaFunction(mainThread=true)
    public final String getConfiguration() throws LuaException {
        PostboxBlockEntity pbbe = this.getBlockEntity();
        if (pbbe == null) {
            throw new LuaException("postbox must be in loaded chunk");
        }
        if (pbbe.acceptsPackages) {
            return "send_receive";
        }
        return "send";
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", this.station.id);
        result.put("pos", ComputerUtil.getPosition(this.pos));
        return result;
    }
}

